<?php $__env->startSection('content'); ?>
<div class="card card-danger">
    <div class="card-header">
        <h3 class="card-title">
            BIG HOSPITALS
        </h3>
    </div>
    <div class="card-body">

        <div class="row">
            <?php $big_four = ['cdh', 'tljph', 'vdh', 'ldzdh']; ?>
            <?php $__currentLoopData = $regular_beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(in_array( strtolower($item->code), $big_four )): ?>
                    <div class="col-md-3 col-12 mb-2">
                        <div class="card">
                            <div class="card-header">
                                <a href="/hospital/<?php echo e($item->id); ?>">
                                    <p class="text-center bg-olive p-2"><?php echo e($item->hospital); ?></p>
                                </a>
                            </div>

                            <div class="card-body">
                                <canvas id="<?php echo e($item->code); ?>" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                            </div>

                            <div class="card-footer text-center">
                                <p class="text-muted">CAPACITY: <?php echo e($item->total_beds); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

    </div>
</div>

<div class="card card-success">
    <div class="card-header">
        <h3 class="card-title">
            SMALL HOSPITALS
        </h3>
    </div>
    <div class="card-body">

        <div class="row">
            <?php $big_four = ['cdh', 'tljph', 'vdh', 'ldzdh']; ?>
            <?php $__currentLoopData = $regular_beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(!in_array( strtolower($item->code), $big_four )): ?>
                    <div class="col-md-3 col-12 mb-2">
                        <div class="card">
                            <div class="card-header">
                                <a href="/hospital/<?php echo e($item->id); ?>">
                                    <p class="text-center bg-olive p-2"><?php echo e($item->hospital); ?></p>
                                </a>
                            </div>

                            <div class="card-body">
                                <canvas id="<?php echo e($item->code); ?>" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                            </div>

                            <div class="card-footer text-center">
                                <p class="text-muted">CAPACITY: <?php echo e($item->total_beds); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function(){

            //view big four hospitals
            <?php $__currentLoopData = $regular_beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <?php if(in_array( strtolower($h_item->code), $big_four )): ?>

                    var occupied=0, available=0
                    <?php $__currentLoopData = $occupied; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($o_item->hospital == $h_item->hospital): ?>
                            occupied = <?php echo e($o_item->occupied); ?>

                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php $__currentLoopData = $available; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($o_item->hospital == $h_item->hospital): ?>
                            available = <?php echo e($o_item->available); ?>

                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    var donutData        = {
                            labels: [
                                'Occupied',
                                'Available'
                            ],
                            datasets: [
                                {
                                data: [occupied,available],
                                backgroundColor : ['#800000', '#00cc00'],
                                }
                            ]
                        }
                    var id = "<?php echo e($h_item->code); ?>"
                    var pieChartCanvas = $('#'+id).get(0).getContext('2d')
                    var pieData        = donutData;
                    var pieOptions     = {
                    maintainAspectRatio : false,
                    responsive : true,
                    }
                    //Create pie or douhnut chart
                    // You can switch between pie and douhnut using the method below.
                    var pieChart = new Chart(pieChartCanvas, {
                    type: 'pie',
                    data: pieData,
                    options: pieOptions
                    })

                <?php endif; ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            // view small hospitals
            <?php $__currentLoopData = $regular_beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <?php if(!in_array( strtolower($h_item->code), $big_four )): ?>

                    var occupied=0, available=0
                    <?php $__currentLoopData = $occupied; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($o_item->hospital == $h_item->hospital): ?>
                            occupied = <?php echo e($o_item->occupied); ?>

                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php $__currentLoopData = $available; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($o_item->hospital == $h_item->hospital): ?>
                            available = <?php echo e($o_item->available); ?>

                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    var donutData        = {
                            labels: [
                                'Occupied',
                                'Available'
                            ],
                            datasets: [
                                {
                                data: [occupied,available],
                                backgroundColor : ['#800000', '#00cc00'],
                                }
                            ]
                        }
                    var id = "<?php echo e($h_item->code); ?>"
                    var pieChartCanvas = $('#'+id).get(0).getContext('2d')
                    var pieData        = donutData;
                    var pieOptions     = {
                    maintainAspectRatio : false,
                    responsive : true,
                    }
                    //Create pie or douhnut chart
                    // You can switch between pie and douhnut using the method below.
                    var pieChart = new Chart(pieChartCanvas, {
                    type: 'pie',
                    data: pieData,
                    options: pieOptions
                    })

                <?php endif; ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/dashboard/index.blade.php ENDPATH**/ ?>