<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Station</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Create Station</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/<?php echo e($hospital->id); ?>" class="btn btn-sm btn-success rounded-0" title="Return to <?php echo e($hospital->hospital); ?> dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <form class="form-horizontal" action="/hospital/station" method="POST">
            <?php echo csrf_field(); ?>
            <?php if(isset($station)): ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="id" value="<?php echo e($station->id); ?>">
            <?php endif; ?>
            <div class="card-body">
                <div class="form-group row">
                    <label for="inputEmail3" class="col-sm-2 col-form-label">Hospital *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" value="<?php echo e($hospital->hospital); ?>" readonly>
                        <input type="hidden" class="form-control" id="hospital_id" name="hospital_id" value="<?php echo e($hospital->id); ?>">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="inputPassword3" class="col-sm-2 col-form-label">Station *</label>
                    <div class="col-sm-10">
                        <?php if(isset($station)): ?>
                            <input type="text" class="form-control" id="station" name="station" value="<?php echo e($station->station); ?>" required>
                        <?php else: ?>
                            <input type="text" class="form-control" id="station" name="station" placeholder="-" required>
                            <?php $__errorArgs = ['station'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span>
                                    <?php echo e($message); ?>

                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="inputPassword3" class="col-sm-2 col-form-label">Description</label>
                    <div class="col-sm-10">
                        <?php if(isset($station)): ?>
                            <input type="text" class="form-control" id="description" name="description" value="<?php echo e($station->description); ?>">
                        <?php else: ?>
                            <input type="text" class="form-control" id="description" name="description" placeholder="-">
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span>
                                    <?php echo e($message); ?>

                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>
                     SAVE
                </button>
            </div>
        </form>
        <?php if(session()->has('station.store') || session()->has('station.update') || session()->has('station.destroy')): ?>
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                <?php if(session()->get('station.store')): ?>
                    New station successfully added!
                <?php elseif(session()->get('station.update')): ?>
                    Update Successful!
                <?php elseif(session()->get('station.destroy')): ?>
                    Delete Successful!
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
    <hr>

    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Station</th>
                    <th>Description</th>
                    <th>Created at</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $stations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($item->station); ?></td>
                        <td><?php echo e($item->description); ?></td>
                        <td><?php echo e($item->created_at); ?></td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/hospital/<?php echo e($item->hospital_id); ?>/station?id=<?php echo e($item->id); ?>" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/station" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <input type="hidden" name="del_station_id" value="<?php echo e($item->id); ?>">
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted">No beds found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/hospitals/station/create.blade.php ENDPATH**/ ?>