<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1><?php echo e($hospital->hospital); ?></h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="/hospital/<?php echo e($hospital->id); ?>"><?php echo e($hospital->hospital); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e($rooms[0]->station); ?></li>
            </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title text-capitalize"><?php echo e($rooms[0]->station); ?> - Rooms</h3>

        <!-- super admin only -->
        <?php if(Auth::user()->role == 3): ?>
            <button class="btn btn-default float-right" data-toggle="modal" data-target="#modal-lg">
                <i class="fa fa-trash"></i>
                Delete this station
            </button>
        <?php endif; ?>
        <!-- super admin only -->

    </div>
    <div class="card-body">
        <div class="row">


            <?php $__currentLoopData = $rooms[0]->room; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-sm-6 col-md-3">

                    <?php if(isset($ref_no)): ?>
                        <a href="/hospital/<?php echo e($item->hospital_id); ?>/station/<?php echo e($item->station_id); ?>/room/<?php echo e($item->id); ?>/bed?ref_no=<?php echo e($ref_no); ?>" class="text-dark">
                    <?php else: ?>
                        <?php if(isset($patient_id)): ?>
                            <a href="/hospital/<?php echo e($item->hospital_id); ?>/station/<?php echo e($item->station_id); ?>/room/<?php echo e($item->id); ?>/bed?transfer=1&id=<?php echo e($patient_id); ?>" class="text-dark">
                        <?php else: ?>
                            <a href="/hospital/<?php echo e($item->hospital_id); ?>/station/<?php echo e($item->station_id); ?>/room/<?php echo e($item->id); ?>/bed" class="text-dark">
                        <?php endif; ?>

                    <?php endif; ?>

                        <div class="info-box border-none">
                            <?php $is_avail=false ?>
                            <?php $__currentLoopData = $beds[0]->bed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($b->room_id == $item->id && $b->status == 1): ?>
                                    <?php $is_avail=true ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <span class="info-box-icon <?php if($is_avail): ?> bg-success <?php else: ?> bg-danger <?php endif; ?> elevation-1"><i class="fas fa-folder"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text text-capitalize"><?php echo e($item->room); ?></span>
                                <span class="font-italic">
                                    <?php $bed_ctr=0 ?>
                                    <?php $__currentLoopData = $beds[0]->bed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($b->room_id == $item->id): ?>
                                            <?php $bed_ctr++ ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <small>Beds = <?php echo e($bed_ctr); ?></small>
                                </span>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <!-- super admin only -->
            <?php if(Auth::user()->role == 3): ?>
                <div class="col-12 col-sm-6 col-md-3">
                    <a href="/hospital/<?php echo e($rooms[0]->hospital_id); ?>/station/<?php echo e($rooms[0]->id); ?>/room/create" class="text-dark">
                        <div class="info-box border-none">
                            <span class="info-box-icon bg-secondary elevation-1"><i class="fas fa-plus"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text text-capitalize">New room</span>
                                <span class="info-box-number">

                                </span>
                            </div>
                        </div>
                    </a>
                </div>

                <?php if(session()->has('room.store')): ?>
                    <?php if(session()->get('room.store')): ?>
                        <div class="alert alert-success alert-dismissible col-12 mx-2" id="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-check"></i> Success!</h5>
                            New room successfully added
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>
            <!-- super admin only -->

        </div>
    </div>
    <div class="card-footer">
        <a href="/hospital/<?php echo e($hospital->id); ?>" class="btn btn-danger btn-sm">
            <i class="fa fa-arrow-left"></i> Back
        </a>
    </div>
</div>

<div class="modal fade" id="modal-lg">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-exclamation-triangle"></i>
                    Delete warning!
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning alert-dismissible mb-0">
                    <h5>
                        This action cannot be undone.<br>
                        Click "Delete" button to delete this station.
                    </h5>
                </div>
            </div>

            <form action="/hospital/station/<?php echo e($rooms[0]->id); ?>" method="post">
                <?php echo method_field('DELETE'); ?>
                <?php echo csrf_field(); ?>
                <div class="modal-footer justify-content-center">
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </div>
            </form>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/hospitals/room/index.blade.php ENDPATH**/ ?>