<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Bed</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Create Bed</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/<?php echo e($hospital->id); ?>" class="btn btn-sm btn-success rounded-0" title="Return to <?php echo e($hospital->hospital); ?> dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <h4 class="text-center text-uppercase">
            <?php echo e($hospital->hospital); ?>

        </h4>
        <h5 class="text-center text-muted">DEPARTMENT BEDS</h5>
        <hr>

        <form class="form-horizontal" action="/department" method="POST">
        <?php if(isset($department)): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>

            <?php echo csrf_field(); ?>
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Bed *</label>
                    <div class="col-sm-10">
                        <?php if(isset($department)): ?>
                            <input type="text" class="form-control" name="bed" value="<?php echo e($department->bed); ?>" autofocus required>
                            <input type="hidden" name="id" value="<?php echo e($department->id); ?>">
                        <?php else: ?>
                            <input type="text" class="form-control" name="bed" value="" autofocus required>
                            <input type="hidden" name="hospital_id" value="<?= $_GET['hospital_id'] ?>">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Description</label>
                    <div class="col-sm-10">
                        <?php if(isset($department)): ?>
                            <input type="text" class="form-control" name="description" value="<?php echo e($department->description); ?>">
                        <?php else: ?>
                            <input type="text" class="form-control" name="description">
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Department *</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" name="type" style="width: 100%;" required>
                            <option value="">-</option>

                            <?php if(isset($department)): ?>
                                <option value="dr" <?php if($department->type == 'dr'): ?> selected <?php endif; ?>>Delivery Room</option>
                                <option value="er" <?php if($department->type == 'er'): ?> selected <?php endif; ?>>Emergency Room</option>
                                <option value="or" <?php if($department->type == 'or'): ?> selected <?php endif; ?>>Operation Room</option>
                                <option value="opd" <?php if($department->type == 'opd'): ?> selected <?php endif; ?>>Outpatient Department</option>
                            <?php else: ?>
                                <option value="dr">Delivery Room</option>
                                <option value="er">Emergency Room</option>
                                <option value="or">Operating Room</option>
                                <option value="opd">Outpatient Department</option>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>

                    <?php if(isset($doctor)): ?>
                        UPDATE
                    <?php else: ?>
                        SAVE
                    <?php endif; ?>
                </button>
            </div>
        </form>
        <?php if(session()->has('department.store') || session()->has('department.update') || session()->has('department.destroy')): ?>
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                <?php if(session()->get('department.store')): ?>
                    New bed successfully added!
                <?php elseif(session()->get('department.update')): ?>
                    Update Successful!
                <?php elseif(session()->get('department.destroy')): ?>
                    Delete Successful!
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
    <hr>
    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Bed</th>
                    <th>Department</th>
                    <th>Description</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $department_beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $db_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($db_item->bed); ?></td>
                        <td>
                            <?php if($db_item->type == 'er'): ?>
                                Emergency Room
                            <?php elseif($db_item->type == 'dr'): ?>
                                Delivery Room
                            <?php elseif($db_item->type == 'or'): ?>
                                Operating Room
                            <?php elseif($db_item->type == 'opd'): ?>
                                Outpatient Department
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($db_item->description); ?></td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/department/edit/<?php echo e($db_item->id); ?>" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/department" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <input type="hidden" name="db_id" value="<?php echo e($db_item->id); ?>">
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted">No beds found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function(){
            //Initialize Select2 Elements
            $('.select2').select2()
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/hospitals/department/create.blade.php ENDPATH**/ ?>