<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Hospitals</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">DRRMOs</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card card-success">
        <div class="card-header">
        </div>
        <div class="card-body">


            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                          <h3 class="card-title">List of City/Municipality Office</h3>

                          <?php if(Auth::user()->role == 3): ?>
                            <a href="/drrmo" class="btn btn-success float-right">
                                <i class="fa fa-plus"></i> NEW
                            </a>
                          <?php endif; ?>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body table-responsive">
                          <table id="tbl_hospitals" class="table table-hover text-nowrap">
                            <thead>
                                <tr>
                                    <th>Code</th>
                                    <th>DRRMO</th>
                                    <th>Address</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $drrmos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="text-capitalize"> <?php echo e($item->code); ?> </td>
                                        <td class="text-capitalize"> <?php echo e($item->drrmo); ?> </td>
                                        <td class="text-capitalize"> <?php echo e($item->address); ?> </td>
                                        <td>
                                            <a href="/hospital/<?php echo e($item->id); ?>">
                                                <i class="fa fa-folder"></i>
                                            </a>

                                            <?php if(Auth::user()->role == 3): ?>
                                                <button class="btn btn-link text-danger" data-toggle="modal" data-target="#modal-hosp<?php echo e($item->id); ?>-delete">
                                                    <i class="fa fa-trash"></i>
                                                </button>

                                                <!-- delete drrmo modal -->
                                                <div class="modal fade" id="modal-hosp<?php echo e($item->id); ?>-delete">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Delete DRRMO Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">

                                                                <h4 >
                                                                    <span class="text-muted">DRRMO:</span> <?php echo e($item->drrmo); ?>

                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/drrmo/<?php echo e($item->id); ?>" method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-danger">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- delete drrmo modal -->
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                <?php endif; ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Code</th>
                                    <th>DRRMO</th>
                                    <th>Address</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                          </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {
            //Initialize Select2 Elements
            $('.select2').select2()

            $("#tbl_hospitals").DataTable({
                "responsive": true, "lengthChange": false, "autoWidth": false,
                "buttons": ["excel"]
            }).buttons().container().appendTo('#tbl_hospitals_wrapper .col-md-6:eq(0)');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/drrmo/index.blade.php ENDPATH**/ ?>