<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1><?php echo e($beds[0]->room); ?></h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="/hospital/<?php echo e($hospital->id); ?>"><?php echo e($hospital->hospital); ?></a></li>
                <li class="breadcrumb-item"><a href="/hospital/<?php echo e($rooms[0]->id); ?>"><?php echo e($rooms[0]->station); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e($beds[0]->room); ?></li>
            </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title text-capitalize"><?php echo e($beds[0]->room); ?> - <?php echo e($beds[0]->description); ?></h3>

        <!-- super admin only -->
        <?php if(Auth::user()->role == 3): ?>
            <button class="btn btn-default float-right" data-toggle="modal" data-target="#modal-lg">
                <i class="fa fa-trash"></i>
                Delete this room
            </button>
        <?php endif; ?>
        <!-- super admin only -->

    </div>
    <div class="card-body">
        <div class="row">


            <?php $__currentLoopData = $beds[0]->bed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-sm-6 col-md-3">
                    <?php if(isset($ref_no)): ?>
                            <div class="info-box border-none">
                                <?php if($item->status == 1): ?>
                                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-bed"></i></span>
                                <?php elseif($item->status == 2): ?>
                                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-bed"></i></span>
                                <?php elseif($item->status == 3): ?>
                                    <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-bed"></i></span>
                                <?php endif; ?>

                                <div class="info-box-content d-flex">


                                        <?php if($item->status == 1): ?>
                                            <span class="info-box-text text-capitalize">
                                                Available
                                                <button class="btn float-right btn-link text-dark" data-toggle="modal" data-target="#bed-<?php echo e($item->id); ?>">
                                                    <i class="fa fa-edit fa-lg"></i>
                                                </button>
                                            </span>

                                        <?php elseif($item->status == 2): ?>
                                            <span class="info-box-text text-capitalize">
                                                Incoming
                                            </span>
                                        <?php elseif($item->status == 3): ?>
                                            <span class="info-box-text text-capitalize">
                                                Occupied
                                            </span>
                                        <?php endif; ?>

                                    <span class="info-box-number">
                                        <?php echo e($item->bed); ?>


                                        <?php if($item->status != 1): ?>
                                            <a class="text-decoration-none text-dark float-right font-italic text-muted font-weight-normal" href="/patient/<?php echo e($item->patient_id); ?>" target="_blank" rel="noopener noreferrer">
                                                Patient Details
                                            </a>
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>

                            <?php if($item->status == 1): ?>
                                <div class="modal fade" id="bed-<?php echo e($item->id); ?>">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">
                                                    <i class="fas fa-check"></i>
                                                    Available!
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="alert alert-default alert-dismissible mb-0">
                                                    <h5>
                                                        This bed is available.<br>
                                                        Click "Submit" to reserve REF #<?php echo e($ref_no); ?> here.
                                                    </h5>
                                                </div>
                                            </div>

                                            <form action="/referral/finish-referral" method="post">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="ref_no" value="<?php echo e($ref_no); ?>">
                                                <input type="hidden" name="bed_id" value="<?php echo e($item->id); ?>">
                                                <div class="modal-footer justify-content-center">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                    <?php else: ?>
                        <?php if(isset($patient_id)): ?>
                            <div class="info-box border-none">
                                <?php if($item->status == 1): ?>
                                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-bed"></i></span>
                                <?php elseif($item->status == 2): ?>
                                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-bed"></i></span>
                                <?php elseif($item->status == 3): ?>
                                    <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-bed"></i></span>
                                <?php endif; ?>

                                <div class="info-box-content d-flex">


                                        <?php if($item->status == 1): ?>
                                            <span class="info-box-text text-capitalize">
                                                Available
                                                <button class="btn float-right btn-link text-dark" data-toggle="modal" data-target="#bed-<?php echo e($item->id); ?>">
                                                    <i class="fa fa-edit fa-lg"></i>
                                                </button>
                                            </span>

                                        <?php elseif($item->status == 2): ?>
                                            <span class="info-box-text text-capitalize">
                                                Incoming
                                            </span>
                                        <?php elseif($item->status == 3): ?>
                                            <span class="info-box-text text-capitalize">
                                                Occupied
                                            </span>
                                        <?php endif; ?>

                                    <span class="info-box-number">
                                        <?php echo e($item->bed); ?>


                                        <?php if($item->status != 1): ?>
                                            <a class="text-decoration-none text-dark float-right font-italic text-muted font-weight-normal" href="/patient/<?php echo e($item->patient_id); ?>" target="_blank" rel="noopener noreferrer">
                                                Patient Details
                                            </a>
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>

                            <?php if($item->status == 1): ?>
                                <div class="modal fade" id="bed-<?php echo e($item->id); ?>">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">
                                                    <i class="fas fa-check"></i>
                                                    Available!
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="alert alert-default alert-dismissible mb-0">
                                                    <h5>
                                                        This bed is available.<br>
                                                        Click "Submit" to transfer patient here.
                                                    </h5>
                                                </div>
                                            </div>

                                            <form action="/patient/transfer" method="post">
                                                <?php echo method_field('PUT'); ?>
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="patient_id" value="<?php echo e($patient_id); ?>">
                                                <input type="hidden" name="bed_id" value="<?php echo e($item->id); ?>">
                                                <div class="modal-footer justify-content-center">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <div class="info-box border-none">
                                <?php if($item->status == 1): ?>
                                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-bed"></i></span>
                                <?php elseif($item->status == 2): ?>
                                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-bed"></i></span>
                                <?php elseif($item->status == 3): ?>
                                    <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-bed"></i></span>
                                <?php endif; ?>

                                <div class="info-box-content">
                                    <span class="info-box-text text-capitalize">
                                        <?php if($item->status == 1): ?>
                                            Available
                                        <?php elseif($item->status == 2): ?>
                                            Incoming
                                        <?php elseif($item->status == 3): ?>
                                            Occupied
                                            <a class="text-decoration-none text-dark float-right tooltip-test" data-toggle="tooltip" data-placement="top" title="Transfer to other bed." href="/hospital/<?php echo e($item->hospital_id); ?>?transfer=1&id=<?php echo e($item->patient_id); ?>" target="_blank" rel="noopener noreferrer">
                                                <i class="fa fa-share fa-lg"></i>
                                            </a>
                                        <?php endif; ?>
                                    </span>
                                    <span class="info-box-number">
                                        <?php echo e($item->bed); ?>


                                        <?php if($item->status != 1): ?>
                                            <a class="text-decoration-none text-dark float-right font-italic text-muted font-weight-normal" title="Tooltip" href="/patient/<?php echo e($item->patient_id); ?>" target="_blank" rel="noopener noreferrer">
                                                Patient Details
                                            </a>
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <!-- super admin only -->
            <?php if(Auth::user()->role == 3): ?>
                <div class="col-12 col-sm-6 col-md-3">
                    <a href="/hospital/<?php echo e($rooms[0]->hospital_id); ?>/station/<?php echo e($rooms[0]->id); ?>/room/<?php echo e($beds[0]->id); ?>/bed/create" class="text-dark">
                        <div class="info-box border-none">
                            <span class="info-box-icon bg-secondary elevation-1"><i class="fas fa-plus"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text text-capitalize">New bed</span>
                                <span class="info-box-number">

                                </span>
                            </div>
                        </div>
                    </a>
                </div>

                <?php if(session()->has('room.store')): ?>
                    <?php if(session()->get('room.store')): ?>
                        <div class="alert alert-success alert-dismissible col-12 mx-2" id="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-check"></i> Success!</h5>
                            New room successfully added
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>
            <!-- super admin only -->

        </div>
    </div>
    <div class="card-footer">
        <a href="/hospital/<?php echo e($hospital->id); ?>/station/<?php echo e($beds[0]->station_id); ?>/room" class="btn btn-danger btn-sm">
            <i class="fa fa-arrow-left"></i> Back
        </a>
    </div>
</div>


<div class="modal fade" id="modal-lg">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-exclamation-triangle"></i>
                    Delete warning!
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning alert-dismissible mb-0">
                    <h5>
                        This action cannot be undone.<br>
                        Click "Delete" button to delete this room.
                    </h5>
                </div>
            </div>

            <form action="/hospital/room/<?php echo e($beds[0]->id); ?>" method="post">
                <?php echo method_field('DELETE'); ?>
                <?php echo csrf_field(); ?>
                <div class="modal-footer justify-content-center">
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </div>
            </form>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/hospitals/bed/index.blade.php ENDPATH**/ ?>