<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Statistics</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Statistics</li>
        </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default color-palette-box">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-file-signature"></i>
                        Total Referrals
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-procedures"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">Patients</span>
                                    <span class="info-box-number">
                                        <?php echo e($patient); ?>

                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">Referrals</span>
                                    <span class="info-box-number">
                                        <?php echo e($referral); ?>

                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-hospital"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">Created by Hospital</span>
                                    <span class="info-box-number">
                                        <?php echo e($hospital); ?>

                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-sm-6 col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-university"></i></span>
                    
                                <div class="info-box-content">
                                    <span class="info-box-text">Created by LGU</span>
                                    <span class="info-box-number">
                                        <?php echo e($lgu); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card card-default color-palette-box">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-file-signature"></i>
                        Referral Status
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="col-12">
                                <div class="info-box">
                                    <span class="info-box-icon bg-default elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                        
                                    <div class="info-box-content">
                                        <span class="info-box-text">On-Process</span>
                                        <span class="info-box-number">
                                            <?php echo e($on_process); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
        
                            <div class="col-12">
                                <div class="info-box">
                                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                        
                                    <div class="info-box-content">
                                        <span class="info-box-text">Referred</span>
                                        <span class="info-box-number">
                                            <?php echo e($referred); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
        
                            <div class="col-12">
                                <div class="info-box">
                                    <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                        
                                    <div class="info-box-content">
                                        <span class="info-box-text">Admitted</span>
                                        <span class="info-box-number">
                                            <?php echo e($admitted); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
        
                            <div class="col-12">
                                <div class="info-box">
                                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-file-medical-alt"></i></span>
                        
                                    <div class="info-box-content">
                                        <span class="info-box-text">Released</span>
                                        <span class="info-box-number">
                                            <?php echo e($released); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
        
                        <div class="col-md-8">
                            <div id="referralStatusContainer" style="height: 370px; width: 100%;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="col-md-12">
            <div class="card card-default color-palette-box">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-hospital"></i>
                        Hospital Referrals
                    </h3>
                </div>
                <div class="card-body">
                    <div id="hospitalChartContainer" style="height: 370px; width: 100%;"></div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card card-default color-palette-box">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-university"></i>
                        LGU Referrals
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 mb-5">
                            <div id="lguB1ChartContainer" style="height: 370px; width: 100%;"></div>
                            <hr>
                        </div>
                        
                        <div class="col-md-12">
                            <div id="lguB2ChartContainer" style="height: 370px; width: 100%;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {

            var hospital_arr = [];

            <?php $__currentLoopData = $hospitals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                hospital_arr.push({ label: '<?php echo e($index); ?>', y: <?php echo e($value); ?> })
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            var hospital = new CanvasJS.Chart("hospitalChartContainer", {
                animationEnabled: true,
                exportEnabled: true,
                theme: "light1", // "light1", "light2", "dark1", "dark2"
                title: {
                    text: "TOTAL CREATED REFERRALS OF EACH HOSPITAL"
                },
                axisY: {
                    title: "NO. OF REFERRALS",
                    includeZero: true
                },
                axisX: {
                    title: "HOSPITALS"
                },
                data: [{
                    type: "column",
                    indexLabel: "{y}",
                    yValueFormatString: "#,##0",
                    dataPoints: hospital_arr
                }]
            });
            hospital.render();


            var lgu_arr_b1 = []
            var lgu_arr_b2 = []
            var ctr = 0
            <?php $__currentLoopData = $lgus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                if(ctr < 15) {
                    lgu_arr_b1.push({ label: '<?php echo e($index); ?>', y: <?php echo e($value); ?> })
                } else {
                    lgu_arr_b2.push({ label: '<?php echo e($index); ?>', y: <?php echo e($value); ?> })
                }
                ctr++
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            var lguB1 = new CanvasJS.Chart("lguB1ChartContainer", {
                animationEnabled: true,
                exportEnabled: true,
                theme: "light1", // "light1", "light2", "dark1", "dark2"
                title: {
                    text: "TOTAL CREATED REFERRALS OF EACH LGU"
                },
                axisY: {
                    title: "NO. OF REFERRALS",
                    includeZero: true
                },
                axisX: {
                    title: "LGU's",
                },
                data: [{
                    type: "column",
                    indexLabel: "{y}",
                    yValueFormatString: "#,##0",
                    dataPoints: lgu_arr_b1
                }]
            });
            lguB1.render();

            var lguB2 = new CanvasJS.Chart("lguB2ChartContainer", {
                animationEnabled: true,
                exportEnabled: true,
                theme: "light1", // "light1", "light2", "dark1", "dark2"
                title: {
                    text: "TOTAL CREATED REFERRALS OF EACH LGU"
                },
                axisY: {
                    title: "NO. OF REFERRALS",
                    includeZero: true
                },
                axisX: {
                    title: "LGU's",
                },
                data: [{
                    type: "column",
                    indexLabel: "{y}",
                    yValueFormatString: "#,##0",
                    dataPoints: lgu_arr_b2
                }]
            });
            lguB2.render();

            CanvasJS.addColorSet("refStatus",
                [//colorSet Array
                "#ffece6",
                "#ffcc00",
                "#e63900",
                "#39ac39"              
                ]);

            var referralStatus = new CanvasJS.Chart("referralStatusContainer", {
                exportEnabled: true,
                animationEnabled: true,
                colorSet: "refStatus",
                title:{
                    text: "REFERRAL STATUS"
                },
                legend:{
                    cursor: "pointer",
                },
                data: [{
                    type: "pie",
                    showInLegend: true,
                    indexLabel: "{name} - {y}",
                    dataPoints: [
                        { y: <?php echo e($on_process); ?>, name: "ON-PROCESS" },
                        { y: <?php echo e($referred); ?>, name: "REFERRED" },
                        { y: <?php echo e($admitted); ?>, name: "ADMITTED" },
                        { y: <?php echo e($released); ?>, name: "RELEASED" }
                    ]
                }]
            });
            referralStatus.render();
            
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/report/admin.blade.php ENDPATH**/ ?>