<?php $__env->startSection('bread-crumb'); ?>
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1><?php echo e($hospital->hospital); ?></h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active"><?php echo e($hospital->hospital); ?></li>
            </ol>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card card-widget widget-user">
    <div class="widget-user-header bg-success">
        <h3 class="widget-user-username"><?php echo e($hospital->hospital); ?></h3>
        <h5 class="widget-user-desc"><?php echo e($hospital->address); ?></h5>
    </div>
    <div class="widget-user-image">
        <img class="img-circle elevation-2" src=" <?php echo e(asset('dist/svg-files/pgno_logo.svg')); ?> " alt="User Avatar">
    </div>
    <div class="card-footer">
        <div class="row">
            <div class="col-sm-3 border-right">
                <div class="description-block">
                    <h5 class="description-header"><?php echo e(count($stations)); ?></h5>
                    <span class="description-text">STATIONS</span>
                </div>
            </div>
            <div class="col-sm-3 border-right">
                <div class="description-block">
                    <h5 class="description-header"><?php echo e(count($rooms)); ?></h5>
                    <span class="description-text">ROOMS</span>
                </div>
            </div>
            <div class="col-sm-3 border-right">
                <div class="description-block">
                    <h5 class="description-header"><?php echo e(count($beds)); ?></h5>
                    <span class="description-text">BEDS</span>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="description-block">
                    <h5 class="description-header">
                        <?php $ctr=0 ?>
                        <?php $__currentLoopData = $beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->status == 1): ?>
                                <?php $ctr++ ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($ctr); ?>

                    </h5>
                    <span class="description-text">AVAILABLE</span>
                </div>
            </div>


        </div>
    </div>
</div>

<div class="card card-default">
    <div class="card-header">
      <h3 class="card-title">
        Ambulance Status
      </h3>
    </div>
    <div class="card-body">

        
        <div class="row">
            <div class="col-12">

                <?php if(Auth::user()->role == 1): ?>
                    <a href="/ambulance/create?hospital_id=<?php echo e($hospital->id); ?>" class="btn btn-sm btn-secondary rounded-0">
                        <i class="fa fa-plus"></i> AMBULANCE
                    </a>

                    <button class="btn btn-sm btn-warning rounded-0" data-toggle="modal" data-target="#modal-ambulance">
                        <i class="fa fa-file"></i> UPDATE LIST
                    </button>

                    <!-- ambulance update list modal -->
                    <div class="modal fade" id="modal-ambulance">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <form action="/ambulance/list" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <input type="hidden" name="hospital_id" value="<?php echo e($hospital->id); ?>">
                                    <div class="modal-header">
                                        <h4 class="modal-title">UPDATE AMBULANCE AVAILABILITY</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="card-body table-responsive p-0">
                                            <table class="table text-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th>Ambulance</th>
                                                        <th>Driver</th>
                                                        <th>Crew</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $ambulances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr>
                                                            <td><?php echo e($item->ambulance); ?></td>
                                                            <td><?php echo e($item->driver); ?></td>
                                                            <td><?php echo e($item->crew); ?></td>
                                                            <td>
                                                                <input type="checkbox" name="status[]" value="<?php echo e($item->id); ?>" <?php if($item->status): ?> checked <?php endif; ?> data-bootstrap-switch data-off-color="danger" data-on-color="success">
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="4" class="text-center">No data available.</td>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                            </div>
                                    </div>
                                    <div class="modal-footer justify-content-center">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-success">Save changes</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- ambulance update list modal -->
                <?php endif; ?>

                <a href="/ambulance/dispatch?hospital_id=<?php echo e($hospital->id); ?>" class="btn btn-sm btn-danger rounded-0">
                    <i class="fa fa-ambulance"></i> DISPATCH
                </a>
            </div>
        </div>
        <hr>


        <div class="row">
            <?php $__empty_1 = true; $__currentLoopData = $ambulances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-sm-6 col-md-3 col-lg-2 col-12 <?php if($item->status): ?> bg-success <?php else: ?> bg-danger <?php endif; ?> rounded p-3 mb-2">
                    <div class="row mb-2">
                        <div class="col-4 d-flex">
                            <?php if($item->status): ?>
                                <img class="w-100 align-self-center border" style="border-radius: 50%" src="<?php echo e(asset('dist/icons/ambulance.png')); ?>" alt="" srcset="">
                            <?php else: ?>
                                <img class="w-100 align-self-center border" style="border-radius: 50%" src="<?php echo e(asset('dist/icons/incomingambulance.gif')); ?>" alt="" srcset="">
                            <?php endif; ?>
                        </div>
                        <div class="col-8">
                            <small class="m-0 text-uppercase"><?php echo e($item->ambulance); ?></small>
                            <br><small class="m-0"><?php echo e($item->status ? 'Available' : 'Occupied'); ?></small>
                            <br><small class="m-0">Driver: <?php echo e($item->driver); ?></small>
                            <br><small class="m-0">Crew: <?php echo e($item->crew); ?></small>
                        </div>
                    </div>

                    <?php if(Auth::user()->role == 1): ?>
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <a href="/ambulance/edit/<?php echo e($item->id); ?>" class="btn btn-block btn-sm btn-default rounded-0">
                                    <i class="fa fa-edit"></i>
                                </a>
                            </div>
                            <div class="col-md-6 col-12">
                                <button class="btn btn-block btn-sm btn-default rounded-0 text-danger" data-toggle="modal" data-target="#modal-ambulance<?php echo e($item->id); ?>-delete">
                                    <i class="fa fa-trash"></i>
                                </button>
                                <!-- delete ambulance modal -->
                                <div class="modal fade" id="modal-ambulance<?php echo e($item->id); ?>-delete">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title text-dark">Delete Confirmation</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body text-dark">
                                                    <div class="row <?php if($item->status): ?> bg-success <?php else: ?> bg-danger <?php endif; ?> rounded p-3 mb-2">
                                                        <div class="col-4 d-flex">
                                                            <?php if($item->status): ?>
                                                                <img class="w-75 align-self-center border" style="border-radius: 50%" src="<?php echo e(asset('dist/icons/ambulance.png')); ?>" alt="" srcset="">
                                                            <?php else: ?>
                                                                <img class="w-75 align-self-center border" style="border-radius: 50%" src="<?php echo e(asset('dist/icons/incomingambulance.gif')); ?>" alt="" srcset="">
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="col-8">
                                                            <small class="m-0 text-uppercase"><?php echo e($item->ambulance); ?></small>
                                                            <br><small class="m-0"><?php echo e($item->status ? 'Available' : 'Occupied'); ?></small>
                                                            <br><small class="m-0">Driver: <?php echo e($item->driver); ?></small>
                                                            <br><small class="m-0">Crew: <?php echo e($item->crew); ?></small>
                                                        </div>
                                                    </div>
                                            </div>
                                            <div class="modal-footer justify-content-center">
                                                <form action="/ambulance" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <input type="hidden" name="ambulance_id" value="<?php echo e($item->id); ?>">
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-danger">Delete Ambulance</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- delete ambulance modal -->
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-12">
                            <?php if($item->ref_id): ?>
                                <a href="/referral/<?php echo e($item->ref_id); ?>" class="btn btn-sm btn-default btn-block rounded-0 mt-3">REF # <?php echo e($item->ref_no); ?></a>
                            <?php else: ?>
                                <small class="font-italic">Last update: </small> <small><?php echo e($item->latest_update); ?></small>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>&nbsp;
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12 text-center">
                        <h3 class="text-muted">No available ambulance.</h3>
                    </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="card card-success card-outline card-tabs">
    <div class="card-body">

        <?php if(Auth::user()->role == 1): ?>
            <div class="row">
                <div class="col-12 mb-3">
                    <a href="/doctor/create?hospital_id=<?php echo e($hospital->id); ?>" class="btn btn-sm btn-success rounded-0">
                        <i class="fa fa-plus"></i> Doctor
                    </a>
                    <a href="/department/create?hospital_id=<?php echo e($hospital->id); ?>" class="btn btn-sm btn-secondary rounded-0">
                        <i class="fa fa-plus"></i> BED
                    </a>
                    <a href="/doctor-sched/create?hospital_id=<?php echo e($hospital->id); ?>" class="btn btn-sm btn-warning rounded-0">
                        <i class="fa fa-calendar" aria-hidden="true"></i> Create Schedule
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <div class="row">

            <div class="col-12 col-md-4 mb-3">
                <div class="card rounded-0">
                    <div class="card-header bg-orange rounded-0">
                        <h5 class="card-title text-uppercase text-white">
                            Emergency Room
                        </h5>
                    </div>

                    <div class="card-body">
                        <!-- EMERGENCY ROOM -->
                        <div class="row">
                            <?php $__empty_1 = true; $__currentLoopData = $er_beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $er_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php if($er_item->status == 1): ?>
                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">
                                        <?php if(isset($referral_id)): ?>
                                            <?php if(Auth::user()->role == 2): ?>
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-dept-bed<?php echo e($er_item->id); ?>-refer">
                                                    <p> <?php echo e($er_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                </button>
                                                <div class="modal fade" id="modal-dept-bed<?php echo e($er_item->id); ?>-refer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Bed details: </span> Emergency Room [<?php echo e($er_item->bed); ?>]
                                                                </h4>
                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/referral/finish-referral" method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="ref_no" value="<?php echo e($referral_no); ?>">
                                                                    <input type="hidden" name="dept_bed_id" value="<?php echo e($er_item->id); ?>">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>

                                        <?php if(isset($trans_ref_id)): ?>
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-erbed<?php echo e($er_item->id); ?>-transfer">
                                                    <p> <?php echo e($er_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                </button>

                                                <div class="modal fade" id="modal-erbed<?php echo e($er_item->id); ?>-transfer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Emergency Room: </span> <?php echo e($er_item->bed); ?>

                                                                </h4>

                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/transfer/<?php echo e($trans_ref_id); ?>" method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('PUT'); ?>
                                                                    <input type="hidden" name="dept_bed_id" value="<?php echo e($er_item->id); ?>">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            <?php else: ?>
                                                <?php if(Auth::user()->role == 1): ?>
                                                    <a href="/referral/create?hospital_id=<?php echo e($er_item->hospital_id); ?>&dept_bed_id=<?php echo e($er_item->id); ?>&internal=true">
                                                <?php else: ?>
                                                    <a href="/referral/create?hospital_id=<?php echo e($er_item->hospital_id); ?>&dept_bed_id=<?php echo e($er_item->id); ?>">
                                                <?php endif; ?>
                                                    <p> <?php echo e($er_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" >
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>&nbsp;
                                <?php else: ?>
                                    <div class="col-2 <?php if($er_item->status == 2): ?> bg-warning <?php else: ?> bg-danger <?php endif; ?> text-white text-center p-2 rounded mb-2 <?php if(request()->get('dbed') == $er_item->id): ?> glowing-circle mx-3 <?php endif; ?>" id="dbed<?php echo e($er_item->id); ?>">

                                        <a href="/referral/<?php echo e($er_item->ref_id); ?>" target="_blank" rel="noopener noreferrer">

                                            <p> <?php echo e($er_item->bed); ?> </p>
                                            <?php if($er_item->status == 2): ?>
                                                <img class="w-100" src="<?php echo e(asset('dist/icons/incoming.gif')); ?>" >
                                            <?php elseif($er_item->status == 3): ?>
                                                <img class="w-100" src="<?php echo e(asset('dist/icons/occupiedbed.png')); ?>" >
                                            <?php endif; ?>

                                            <?php if(isset($er_item->ref_no)): ?>
                                                <small>REF # <?php echo e($er_item->ref_no); ?></small>
                                            <?php endif; ?>

                                        </a>

                                    </div>&nbsp;
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted p-0 m-0">
                                    No beds found.
                                </p>
                            <?php endif; ?>
                        </div>
                        <!-- EMERGENCY ROOM -->
                        <hr>
                        <div class="row">
                            <?php $__empty_1 = true; $__currentLoopData = $er_doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $erdr_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="col-12 bg-gray p-2 pl-3 rounded mb-2">
                                    <div class="d-flex">
                                        <img class="w-25 h-25" src="<?php echo e(asset('dist/icons/doctor.png')); ?>" alt="" srcset="">
                                        <h5 class="align-self-center p-0 m-0 ml-2">
                                            <?php echo e($erdr_item->doctor); ?> <small class="font-italic">[ <?php echo e($erdr_item->specialty); ?> ] [ <?php echo e($erdr_item->remarks); ?> ]</small>
                                        </h5>
                                    </div>
                                    <?php $in=date_create($erdr_item->in); $out=date_create($erdr_item->out);  ?>
                                    <small class="p-0 m-0 float-right">  <?php echo e(date_format($in,"g:i A")); ?> - <?php echo e(date_format($out,"g:i A")); ?></small>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted p-0 m-0">
                                    No schedule of doctors found for this month.
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 mb-3">
                <div class="card rounded-0">
                    <div class="card-header rounded-0 bg-success">
                        <h5 class="card-title text-uppercase text-white">
                            Operating Room
                        </h5>
                    </div>

                    <div class="card-body">
                        <!-- OPERATING ROOM -->
                        <div class="row">
                            <?php $__empty_1 = true; $__currentLoopData = $or_beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $or_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php if($or_item->status == 1): ?>
                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">
                                        <?php if(isset($referral_id)): ?>
                                            <?php if(Auth::user()->role == 2): ?>
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-dept-bed<?php echo e($or_item->id); ?>-refer">
                                                    <p> <?php echo e($or_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                </button>
                                                <div class="modal fade" id="modal-dept-bed<?php echo e($or_item->id); ?>-refer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Bed details: </span> Emergency Room [<?php echo e($or_item->bed); ?>]
                                                                </h4>
                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/referral/finish-referral" method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="ref_no" value="<?php echo e($referral_no); ?>">
                                                                    <input type="hidden" name="dept_bed_id" value="<?php echo e($or_item->id); ?>">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>

                                            <?php if(isset($trans_ref_id)): ?>
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-orbed<?php echo e($or_item->id); ?>-transfer">
                                                    <p> <?php echo e($or_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                </button>

                                                <div class="modal fade" id="modal-orbed<?php echo e($or_item->id); ?>-transfer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Delivery Room: </span> <?php echo e($or_item->bed); ?>

                                                                </h4>

                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/transfer/<?php echo e($trans_ref_id); ?>" method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('PUT'); ?>
                                                                    <input type="hidden" name="dept_bed_id" value="<?php echo e($or_item->id); ?>">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            <?php else: ?>
                                                <?php if(Auth::user()->role == 1): ?>
                                                    <a href="/referral/create?hospital_id=<?php echo e($or_item->hospital_id); ?>&dept_bed_id=<?php echo e($or_item->id); ?>&internal=true">
                                                <?php else: ?>
                                                    <a href="/referral/create?hospital_id=<?php echo e($or_item->hospital_id); ?>&dept_bed_id=<?php echo e($or_item->id); ?>">
                                                <?php endif; ?>

                                                    <p> <?php echo e($or_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" >


                                                    </a>
                                            <?php endif; ?>

                                        <?php endif; ?>
                                    </div>&nbsp;
                                <?php else: ?>
                                    <div class="col-2 <?php if($or_item->status == 2): ?> bg-warning <?php else: ?> bg-danger <?php endif; ?> text-white text-center p-2 rounded mb-2  <?php if(request()->get('dbed') == $or_item->id): ?> glowing-circle mx-3 <?php endif; ?>" id="dbed<?php echo e($or_item->id); ?>">

                                        <a href="/referral/<?php echo e($or_item->ref_id); ?>" target="_blank" rel="noopener noreferrer">

                                            <p> <?php echo e($or_item->bed); ?> </p>
                                            <?php if($or_item->status == 2): ?>
                                                <img class="w-100" src="<?php echo e(asset('dist/icons/incoming.gif')); ?>" >
                                            <?php elseif($or_item->status == 3): ?>
                                                <img class="w-100" src="<?php echo e(asset('dist/icons/occupiedbed.png')); ?>" >
                                            <?php endif; ?>

                                            <?php if(isset($or_item->ref_no)): ?>
                                                <small>REF # <?php echo e($or_item->ref_no); ?></small>
                                            <?php endif; ?>


                                        </a>

                                    </div>&nbsp;
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted p-0 m-0">
                                    No beds found.
                                </p>
                            <?php endif; ?>
                        </div>
                        <!-- OPERATING ROOM -->
                        <hr>
                        <div class="row">
                            <?php $__empty_1 = true; $__currentLoopData = $or_doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ordr_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="col-12 bg-gray p-2 pl-3 rounded mb-2">
                                    <div class="d-flex">
                                        <img class="w-25 h-25" src="<?php echo e(asset('dist/icons/doctor.png')); ?>" alt="" srcset="">
                                        <h5 class="align-self-center p-0 m-0 ml-2">
                                            <?php echo e($ordr_item->doctor); ?> <small class="font-italic">[ <?php echo e($ordr_item->specialty); ?> ] [ <?php echo e($ordr_item->remarks); ?> ]</small>
                                        </h5>
                                    </div>
                                    <?php $in=date_create($ordr_item->in); $out=date_create($ordr_item->out);  ?>
                                    <small class="p-0 m-0 float-right">  <?php echo e(date_format($in,"g:i A")); ?> - <?php echo e(date_format($out,"g:i A")); ?></small>
                                </div>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted p-0 m-0">
                                    No schedule of doctors found for this month.
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 mb-3">
                <div class="card rounded-0">
                    <div class="card-header bg-info rounded-0">
                        <h5 class="card-title text-uppercase text-white">
                            Delivery Room
                        </h5>
                    </div>

                    <div class="card-body">
                        <!-- DELIVERY ROOM -->
                        <div class="row">
                            <?php $__empty_1 = true; $__currentLoopData = $dr_beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dr_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php if($dr_item->status == 1): ?>
                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">
                                        <?php if(isset($referral_id)): ?>
                                            <?php if(Auth::user()->role == 2): ?>
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-dept-bed<?php echo e($dr_item->id); ?>-refer">
                                                    <p> <?php echo e($dr_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                </button>
                                                <div class="modal fade" id="modal-dept-bed<?php echo e($dr_item->id); ?>-refer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Bed details: </span> Emergency Room [<?php echo e($dr_item->bed); ?>]
                                                                </h4>
                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/referral/finish-referral" method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="ref_no" value="<?php echo e($referral_no); ?>">
                                                                    <input type="hidden" name="dept_bed_id" value="<?php echo e($dr_item->id); ?>">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>

                                            <?php if(isset($trans_ref_id)): ?>
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-drbed<?php echo e($dr_item->id); ?>-transfer">
                                                    <p> <?php echo e($dr_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                </button>

                                                <div class="modal fade" id="modal-drbed<?php echo e($dr_item->id); ?>-transfer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Delivery Room: </span> <?php echo e($dr_item->bed); ?>

                                                                </h4>

                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/transfer/<?php echo e($trans_ref_id); ?>" method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('PUT'); ?>
                                                                    <input type="hidden" name="dept_bed_id" value="<?php echo e($dr_item->id); ?>">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <?php if(Auth::user()->role == 1): ?>
                                                    <a href="/referral/create?hospital_id=<?php echo e($dr_item->hospital_id); ?>&dept_bed_id=<?php echo e($dr_item->id); ?>&internal=true">
                                                <?php else: ?>
                                                    <a href="/referral/create?hospital_id=<?php echo e($dr_item->hospital_id); ?>&dept_bed_id=<?php echo e($dr_item->id); ?>">
                                                <?php endif; ?>

                                                    <p> <?php echo e($dr_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" >

                                                </a>
                                            <?php endif; ?>

                                        <?php endif; ?>



                                    </div>&nbsp;
                                <?php else: ?>
                                    <div class="col-2 <?php if($dr_item->status == 2): ?> bg-warning <?php else: ?> bg-danger <?php endif; ?> text-white text-center p-2 rounded mb-2  <?php if(request()->get('dbed') == $dr_item->id): ?> glowing-circle mx-3 <?php endif; ?>" id="dbed<?php echo e($dr_item->id); ?>">


                                        <a href="/referral/<?php echo e($dr_item->ref_id); ?>" target="_blank" rel="noopener noreferrer">

                                            <p> <?php echo e($dr_item->bed); ?> </p>
                                            <?php if($dr_item->status == 2): ?>
                                                <img class="w-100" src="<?php echo e(asset('dist/icons/incoming.gif')); ?>" >
                                            <?php elseif($dr_item->status == 3): ?>
                                                <img class="w-100" src="<?php echo e(asset('dist/icons/occupiedbed.png')); ?>" >
                                            <?php endif; ?>

                                            <?php if(isset($dr_item->ref_no)): ?>
                                                <small>REF # <?php echo e($dr_item->ref_no); ?></small>
                                            <?php endif; ?>

                                        </a>


                                    </div>&nbsp;
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted p-0 m-0">
                                    No beds found.
                                </p>
                            <?php endif; ?>
                        </div>
                        <!-- DELIVERY ROOM -->
                        <hr>
                        <div class="row">
                            <?php $__empty_1 = true; $__currentLoopData = $dr_doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $drdr_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="col-12 bg-gray p-2 pl-3 rounded mb-2">
                                    <div class="d-flex">
                                        <img class="w-25 h-25" src="<?php echo e(asset('dist/icons/doctor.png')); ?>" alt="" srcset="">
                                        <h5 class="align-self-center p-0 m-0 ml-2">
                                            <?php echo e($drdr_item->doctor); ?> <small class="font-italic">[ <?php echo e($drdr_item->specialty); ?> ] [ <?php echo e($drdr_item->remarks); ?> ]</small>
                                        </h5>
                                    </div>
                                    <?php $in=date_create($drdr_item->in); $out=date_create($drdr_item->out);  ?>
                                    <small class="p-0 m-0 float-right">  <?php echo e(date_format($in,"g:i A")); ?> - <?php echo e(date_format($out,"g:i A")); ?></small>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted p-0 m-0">
                                    No schedule of doctors found for this month.
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- OPD -->
            <div class="col-12 col-md-4 mb-3">
                <div class="card rounded-0">
                    <div class="card-header bg-primary rounded-0">
                        <h5 class="card-title text-uppercase text-white">
                            OUTPATIENT DEPARTMENT
                        </h5>
                    </div>

                    <div class="card-body">
                        <!-- OUTPATIENT DEPARTMENT -->
                        <div class="row">
                            <?php $__empty_1 = true; $__currentLoopData = $opd_beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opd_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php if($opd_item->status == 1): ?>
                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">
                                        <?php if(isset($referral_id)): ?>
                                            <?php if(Auth::user()->role == 2): ?>
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-dept-bed<?php echo e($opd_item->id); ?>-refer">
                                                    <p> <?php echo e($opd_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                </button>
                                                <div class="modal fade" id="modal-dept-bed<?php echo e($opd_item->id); ?>-refer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Bed details: </span> Outpatient Department [<?php echo e($opd_item->bed); ?>]
                                                                </h4>
                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/referral/finish-referral" method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="ref_no" value="<?php echo e($referral_no); ?>">
                                                                    <input type="hidden" name="dept_bed_id" value="<?php echo e($opd_item->id); ?>">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>

                                            <?php if(isset($trans_ref_id)): ?>
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-opdbed<?php echo e($opd_item->id); ?>-transfer">
                                                    <p> <?php echo e($opd_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                </button>

                                                <div class="modal fade" id="modal-opdbed<?php echo e($opd_item->id); ?>-transfer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Outpatient Department: </span> <?php echo e($opd_item->bed); ?>

                                                                </h4>

                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/transfer/<?php echo e($trans_ref_id); ?>" method="post">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('PUT'); ?>
                                                                    <input type="hidden" name="dept_bed_id" value="<?php echo e($opd_item->id); ?>">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <?php if(Auth::user()->role == 1): ?>
                                                    <a href="/referral/create?hospital_id=<?php echo e($opd_item->hospital_id); ?>&dept_bed_id=<?php echo e($opd_item->id); ?>&internal=true">
                                                <?php else: ?>
                                                    <a href="/referral/create?hospital_id=<?php echo e($opd_item->hospital_id); ?>&dept_bed_id=<?php echo e($opd_item->id); ?>">
                                                <?php endif; ?>

                                                    <p> <?php echo e($opd_item->bed); ?> </p>
                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" >

                                                </a>
                                            <?php endif; ?>

                                        <?php endif; ?>



                                    </div>&nbsp;
                                <?php else: ?>
                                    <div class="col-2 <?php if($opd_item->status == 2): ?> bg-warning <?php else: ?> bg-danger <?php endif; ?> text-white text-center p-2 rounded mb-2  <?php if(request()->get('dbed') == $opd_item->id): ?> glowing-circle mx-3 <?php endif; ?>" id="dbed<?php echo e($opd_item->id); ?>">


                                        <a href="/referral/<?php echo e($opd_item->ref_id); ?>" target="_blank" rel="noopener noreferrer">

                                            <p> <?php echo e($opd_item->bed); ?> </p>
                                            <?php if($opd_item->status == 2): ?>
                                                <img class="w-100" src="<?php echo e(asset('dist/icons/incoming.gif')); ?>" >
                                            <?php elseif($opd_item->status == 3): ?>
                                                <img class="w-100" src="<?php echo e(asset('dist/icons/occupiedbed.png')); ?>" >
                                            <?php endif; ?>

                                            <?php if(isset($opd_item->ref_no)): ?>
                                                <small>REF # <?php echo e($opd_item->ref_no); ?></small>
                                            <?php endif; ?>

                                        </a>


                                    </div>&nbsp;
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted p-0 m-0">
                                    No beds found.
                                </p>
                            <?php endif; ?>
                        </div>
                        <!-- OUTPATIENT DEPARTMENT -->
                        <hr>
                        <div class="row">
                            <?php $__empty_1 = true; $__currentLoopData = $opd_doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opddr_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="col-12 bg-gray p-2 pl-3 rounded mb-2">
                                    <div class="d-flex">
                                        <img class="w-25 h-25" src="<?php echo e(asset('dist/icons/doctor.png')); ?>" alt="" srcset="">
                                        <h5 class="align-self-center p-0 m-0 ml-2">
                                            <?php echo e($opddr_item->doctor); ?> <small class="font-italic">[ <?php echo e($opddr_item->specialty); ?> ] [ <?php echo e($opddr_item->remarks); ?> ]</small>
                                        </h5>
                                    </div>
                                    <?php $in=date_create($opddr_item->in); $out=date_create($opddr_item->out);  ?>
                                    <small class="p-0 m-0 float-right">  <?php echo e(date_format($in,"g:i A")); ?> - <?php echo e(date_format($out,"g:i A")); ?></small>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted p-0 m-0">
                                    No schedule of doctors found for this month.
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- OPD -->
        </div>
    </div>
</div>

<?php if(Auth::user()->role != 2): ?>
    <a href="/hospital/<?php echo e($hospital->id); ?>/station" class="btn btn-sm rounded-0 btn-secondary mb-3">
        <i class="fa fa-plus"></i> STATION
    </a>
<?php endif; ?>

<div class="card card-success card-outline card-tabs">
    <div class="card-header p-0 pt-1 border-bottom-0">

        <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
            <?php $prev_station1 = ''; $f=true; $tab_ctr=1; ?>
            <?php $__empty_1 = true; $__currentLoopData = $stations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>


                <?php if(request()->has('station')): ?>
                    <li class="nav-item <?php if(request()->get('station') == $item->id): ?> active <?php endif; ?>">
                        <a class="nav-link" id="custom-tabs-<?php echo e($item->id); ?>-tab" data-toggle="pill" href="#custom-tabs-<?php echo e($item->id); ?>-home" role="tab" aria-controls="custom-tabs-<?php echo e($item->id); ?>-home" aria-selected="true">
                            <?php echo e($item->station); ?>

                        </a>
                    </li>
                <?php else: ?>
                    <?php if($f): ?>
                        <li class="nav-item">
                            <a class="nav-link active" id="custom-tabs-<?php echo e($item->id); ?>-tab" data-toggle="pill" href="#custom-tabs-<?php echo e($item->id); ?>-home" role="tab" aria-controls="custom-tabs-<?php echo e($item->id); ?>-home" aria-selected="true">
                                <?php echo e($item->station); ?>

                            </a>
                        </li>
                        <?php $f=false; ?>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" id="custom-tabs-<?php echo e($item->id); ?>-tab" data-toggle="pill" href="#custom-tabs-<?php echo e($item->id); ?>-home" role="tab" aria-controls="custom-tabs-<?php echo e($item->id); ?>-home" aria-selected="true">
                                <?php echo e($item->station); ?>

                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <!--<h4 class="text-center text-muted">No record found.</h4>-->
            <?php endif; ?>
        </ul>
    </div>
    <div class="card-body">
        <div class="tab-content" id="custom-tabs-three-tabContent">
            <?php $prev_station = ''; $f=true; $tab_ctr=1; $ctr=1; ?>

            <?php $__empty_1 = true; $__currentLoopData = $stations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                <?php if(request()->has('station')): ?>
                    <div class="tab-pane fade <?php if(request()->get('station') == $item->id): ?> active show <?php endif; ?>" id="custom-tabs-<?php echo e($item->id); ?>-home" role="tabpanel" aria-labelledby="custom-tabs-<?php echo e($item->id); ?>-home-tab">
                <?php else: ?>
                    <div class="tab-pane fade <?php if($f): ?> active show <?php endif; ?>" id="custom-tabs-<?php echo e($item->id); ?>-home" role="tabpanel" aria-labelledby="custom-tabs-<?php echo e($item->id); ?>-home-tab">
                <?php endif; ?>


                    <?php if(Auth::user()->role != 2): ?>
                        <div class="row">
                            <div class="col-12">
                                <a href="/hospital/<?php echo e($item->hospital_id); ?>/station/<?php echo e($item->id); ?>/room/create" class="btn btn-sm rounded-0 btn-secondary text-center">
                                    <i class="fa fa-plus"></i> ROOM
                                </a>

                                <button class="btn btn-sm rounded-0 btn-danger" data-toggle="modal" data-target="#modal-station<?php echo e($item->id); ?>-delete">
                                    <i class="fa fa-trash"></i> STATION
                                </button>
                                <!-- delete station modal -->
                                <div class="modal fade" id="modal-station<?php echo e($item->id); ?>-delete">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">Delete Confirmation</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body text-center py-4">
                                                <h3>
                                                    <span class="text-muted">Station details: </span> <span class="text-uppercase"><?php echo e($item->station); ?></span>
                                                </h3>
                                            </div>
                                            <div class="modal-footer justify-content-center">
                                                <form action="/station" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <input type="hidden" name="del_station_id" value="<?php echo e($item->id); ?>">
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-danger">Delete Station</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- delete station modal -->
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <?php $__empty_2 = true; $__currentLoopData = $rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                            <?php if($item->id == $r_item->station_id): ?>
                                <div class="col-sm-6 col-md-4 col-12 bg-light mt-3 p-2">
                                    <h5 class="bg-dark mt-3 text-center p-2"> <?php echo e($r_item->room); ?> </h5>
                                    <center>
                                        <span class="text-muted font-italic"><?php echo e($r_item->description); ?></span>
                                    </center>

                                    <?php if(Auth::user()->role != 2): ?>
                                        <!-- add bed -->
                                        <div class="row">
                                            <div class="col-12">
                                                <a href="/hospital/<?php echo e($r_item->hospital_id); ?>/station/<?php echo e($r_item->station_id); ?>/room/<?php echo e($r_item->id); ?>/bed/create" class="btn btn-sm rounded-0 btn-secondary mb-3">
                                                    <i class="fa fa-plus"></i> BED
                                                </a>
                                            </div>
                                        </div>
                                        <!-- add bed -->
                                    <?php endif; ?>

                                    <!-- beds container -->
                                    <div class="row p-2 justify-content-center">
                                        <?php $__empty_3 = true; $__currentLoopData = $beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_3 = false; ?>

                                            <?php if($r_item->id == $b_item->room_id): ?>

                                                <?php if($b_item->status == 1): ?>
                                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">

                                                        <?php if(isset($referral_id)): ?>
                                                            <!-- if referral is on going -->
                                                            <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-bed<?php echo e($b_item->id); ?>-refer">
                                                                <p> <?php echo e($b_item->bed); ?> </p>
                                                                <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                            </button>

                                                            <div class="modal fade" id="modal-bed<?php echo e($b_item->id); ?>-refer">
                                                                <div class="modal-dialog">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-body text-dark">
                                                                            <h4 class="nb-3">
                                                                                <span class="text-muted">Bed details: </span> <?php echo e($r_item->room); ?> - <?php echo e($b_item->bed); ?>

                                                                            </h4>

                                                                            <h4 >
                                                                                <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                            </h4>
                                                                        </div>
                                                                        <div class="modal-footer justify-content-center">
                                                                            <form action="/referral/finish-referral" method="post">
                                                                                <?php echo csrf_field(); ?>
                                                                                <input type="hidden" name="ref_no" value="<?php echo e($referral_no); ?>">
                                                                                <input type="hidden" name="bed_id" value="<?php echo e($b_item->id); ?>">
                                                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!-- if referral is on going -->
                                                        <?php else: ?>

                                                            <?php if(isset($trans_ref_id)): ?>
                                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-bed<?php echo e($b_item->id); ?>-refer">
                                                                    <p> <?php echo e($b_item->bed); ?> </p>
                                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">
                                                                </button>

                                                                <div class="modal fade" id="modal-bed<?php echo e($b_item->id); ?>-refer">
                                                                    <div class="modal-dialog">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                    <span aria-hidden="true">&times;</span>
                                                                                </button>
                                                                            </div>
                                                                            <div class="modal-body text-dark">
                                                                                <h4 class="nb-3">
                                                                                    <span class="text-muted">Bed details: </span> <?php echo e($r_item->room); ?> - <?php echo e($b_item->bed); ?>

                                                                                </h4>

                                                                                <h4 >
                                                                                    <span class="text-muted">Referral no:</span> <?php echo e($referral_no); ?>

                                                                                </h4>
                                                                            </div>
                                                                            <div class="modal-footer justify-content-center">
                                                                                <form action="/transfer/<?php echo e($trans_ref_id); ?>" method="post">
                                                                                    <?php echo csrf_field(); ?>
                                                                                    <?php echo method_field('PUT'); ?>
                                                                                    <input type="hidden" name="bed_id" value="<?php echo e($b_item->id); ?>">
                                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                                </form>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php else: ?>
                                                                <?php if(Auth::user()->role == 2): ?>
                                                                    <a href="/referral/create?hospital_id=<?php echo e($b_item->hospital_id); ?>&bed_id=<?php echo e($b_item->id); ?>">
                                                                <?php else: ?>
                                                                    <a href="/referral/create?hospital_id=<?php echo e($b_item->hospital_id); ?>&bed_id=<?php echo e($b_item->id); ?>&internal=true">
                                                                <?php endif; ?>

                                                                    <p> <?php echo e($b_item->bed); ?> </p>
                                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/vacantbed.png')); ?>" alt="" srcset="">

                                                                </a>
                                                            <?php endif; ?>

                                                        <?php endif; ?>

                                                    </div>&nbsp;
                                                <?php else: ?>
                                                    <div id="bed<?php echo e($b_item->id); ?>" class="col-2 <?php if($b_item->status == 2): ?> bg-warning <?php elseif($b_item->status == 3): ?> bg-danger <?php endif; ?> text-white text-center p-2 rounded mb-2 <?php if(request()->get('bed') == $b_item->id): ?> glowing-circle mx-3 <?php endif; ?>">
                                                        <?php if($b_item->patient_id != null): ?>
                                                            <a href="/patient/<?php echo e($b_item->patient_id); ?>" target="_blank" rel="noopener noreferrer">
                                                                <p> <?php echo e($b_item->bed); ?> </p>

                                                                <?php if($b_item->status == 2): ?>
                                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/incoming.gif')); ?>" alt="" srcset="">
                                                                <?php elseif($b_item->status == 3): ?>
                                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/occupiedbed.png')); ?>" alt="" srcset="">
                                                                <?php endif; ?>

                                                                <?php if(isset($b_item->ref_no)): ?>
                                                                    <small>REF # <?php echo e($b_item->ref_no); ?></small>
                                                                <?php endif; ?>

                                                            </a>
                                                        <?php else: ?>

                                                            <a href="/patient/<?php echo e($b_item->patient_id); ?>">
                                                                <p> <?php echo e($b_item->bed); ?> </p>
                                                                <?php if($b_item->status == 2): ?>
                                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/incoming.gif')); ?>" alt="" srcset="">
                                                                <?php elseif($b_item->status == 3): ?>
                                                                    <img class="w-100" src="<?php echo e(asset('dist/icons/occupiedbed.png')); ?>" alt="" srcset="">
                                                                <?php endif; ?>
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>&nbsp;
                                                <?php endif; ?>

                                            <?php endif; ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_3): ?>

                                        <?php endif; ?>
                                    </div>
                                    <!-- beds container -->

                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                        <?php endif; ?>
                    </div>

                    <!-- no ref bed -->
                    <div class="modal fade" id="modal-no-ref-bed">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title text-muted">NOTE:</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body text-dark">
                                    <h4 class="nb-3">
                                        No refferal found on this bed.
                                    </h4>

                                    <h4 >
                                        This is manually updated by the hospital.
                                    </h4>
                                </div>
                                <div class="modal-footer justify-content-center">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- no ref bed -->


                </div>
                <?php if($f): ?>
                    <?php $f=false; ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php $f=true; ?>
                <?php $__empty_1 = true; $__currentLoopData = $stations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                    <?php if(Auth::user()->role != 2): ?>
                        <div class="tab-pane fade <?php if($f): ?> active show <?php endif; ?>" id="custom-tabs-<?php echo e($item->id); ?>-home" role="tabpanel" aria-labelledby="custom-tabs-<?php echo e($item->id); ?>-home-tab">
                            <div class="row">
                                <div class="col-12">
                                    <a href="/hospital/<?php echo e($item->hospital_id); ?>/station/<?php echo e($item->id); ?>/room/create" class="btn btn-sm rounded-0 btn-secondary text-center">
                                        <i class="fa fa-plus"></i> ROOM
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if($f): ?>
                        <?php $f=false; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                <?php endif; ?>
                <h4 class="text-center text-muted">No record found.</h4>
            <?php endif; ?>

        </div>
    </div>
    <!-- /.card -->
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(function () {
            $("#tbl-created-referrals").DataTable({
                "responsive": true, "lengthChange": false, "autoWidth": false,
                "buttons": ["colvis"]
            }).buttons().container().appendTo('#tbl-created-referrals_wrapper .col-md-6:eq(0)');

            $("input[data-bootstrap-switch]").each(function(){
                $(this).bootstrapSwitch('state', $(this).prop('checked'));
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/hospitals/show.blade.php ENDPATH**/ ?>