<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'One Hospital')); ?></title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">

    <!-- Font Awesome -->
    <link rel="stylesheet" href=" <?php echo e(asset('plugins/fontawesome-free/css/all.min.css')); ?> ">
    <!-- pace-progress -->
    <link rel="stylesheet" href=" <?php echo e(asset('plugins/pace-progress/themes/black/pace-theme-flat-top.css')); ?> ">
     <!-- DataTables -->
    <link rel="stylesheet" href=" <?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?> ">
    <link rel="stylesheet" href=" <?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?> ">
    <link rel="stylesheet" href=" <?php echo e(asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?> ">
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href=" <?php echo e(asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?> ">
    <!-- Select2 -->
    <link rel="stylesheet" href=" <?php echo e(asset('plugins/select2/css/select2.min.css')); ?> ">
    <link rel="stylesheet" href=" <?php echo e(asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?> ">
    <!-- adminlte-->
    <link rel="stylesheet" href=" <?php echo e(asset('dist/css/adminlte.min.css')); ?> ">

    <!-- Styles -->
    
    <style>
        .glowing-circle {
            background-color: #fff;
            -webkit-animation: glowing 1s ease-in-out infinite alternate;
            -moz-animation: glowing 1s ease-in-out infinite alternate;
            animation: glowing 1s ease-in-out infinite alternate;
        }
        @-webkit-keyframes glowing {
            from {
                box-shadow: 0 0 10px #fff, 0 0 20px #fff, 0 0 30px #02680f, 0 0 40px #0ff, 0 0 50px #07f424, 0 0 60px #07f424, 0 0 70px #07f424;
            }
            to {
                box-shadow: 0 0 20px #fff, 0 0 30px #02b018, 0 0 40px #02b018, 0 0 50px #02b018, 0 0 60px #02b018, 0 0 70px #02b018, 0 0 80px #02b018;
            }
        }

        .image-input
            text-aling: center
            input
                display: none !important
            label
                display: block
                color: #FFF
                background: #000	
                padding: .3rem .6rem
                font-size: 115%
                cursor: pointer
                i
                    font-size: 125%
                    margin-right: .3rem
                &:hover
                    i
                        animation: shake .35s
            img
                max-width: 175px
                display: none
            span
                display: none
                text-align: center
                cursor: pointer

            
    </style>
</head>

<style>
    input:read-only, textarea:read-only {
        background-color: white !important;
    }
</style>

<?php $page = Route::currentRouteName();?>

<?php if(auth()->guard()->guest()): ?>
    <body class="hold-transition <?php if($page == 'login'): ?> login-page <?php else: ?> register-page <?php endif; ?>">
<?php else: ?>
    <body class="hold-transition sidebar-mini ">
<?php endif; ?>

    <div id="app">
    <?php if(auth()->guard()->guest()): ?>

        <?php if($page == 'login'): ?>
            <div class="login-box">
                <div class="login-logo">
                    <a href="#"><b>ONE HOSPITAL</b></a>

                </div>
                <!-- /.login-logo -->
                <div class="card">
                <div class="card-body login-card-body">
                    <p class="login-box-msg">Sign in to start your session</p>

                    <form action="<?php echo e(route('login')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="input-group mb-3">
                            <input id="email" type="email" placeholder="Email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-envelope"></span>
                                </div>
                            </div>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="input-group mb-3">
                            <input id="password" type="password" placeholder="Password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" required autocomplete="current-password">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-lock"></span>
                                </div>
                            </div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="row">
                            <div class="col-8">
                                <div class="icheck-primary">
                                    <input type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                    <label for="remember">
                                    Remember Me
                                    </label>
                                </div>
                            </div>
                            <!-- /.col -->
                            <div class="col-4">
                                <button type="submit" class="btn btn-primary btn-block">Sign In</button>
                            </div>
                            <!-- /.col -->
                        </div>
                    </form>

                    <?php if(Route::has('password.request')): ?>
                        <p class="mb-1">
                            <a class="text-center" href="<?php echo e(route('password.request')); ?>">
                                <?php echo e(__('Forgot Your Password?')); ?>

                            </a>
                        </p>
                    <?php endif; ?>
                    <p class="mb-0">
                        <a href="/register" class="text-center">Register an account</a>
                    </p>

                    <p class="text-wrap mt-4">
                        <?php if(session()->has('inactive')): ?>
                            <?php echo e(session()->get('inactive')); ?>

                        <?php endif; ?>
                    </p>
                </div>
                <!-- /.login-card-body -->
                </div>

            </div>


        <?php else: ?>
            <div class="register-box">
                <div class="register-logo">
                    <a href="#"><b>ONE HOSPITAL</b></a>
                </div>

                <div class="card">
                    <div class="card-body register-card-body">
                        <p class="login-box-msg">Register an account</p>

                        <form action="<?php echo e(route('register')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="input-group mb-3">
                                <input id="fname" type="text" placeholder="First name" class="form-control <?php $__errorArgs = ['fname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="fname" value="<?php echo e(old('fname')); ?>" required autocomplete="fname" autofocus>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-user"></span>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['fname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="input-group mb-3">
                                <input id="lname" type="text" placeholder="Last name" class="form-control <?php $__errorArgs = ['lname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="lname" value="<?php echo e(old('lname')); ?>" required autocomplete="lname" autofocus>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-user"></span>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['lname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="input-group mb-3">
                                <input id="email" type="email" placeholder="Email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-envelope"></span>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="input-group mb-3">
                                <input id="password" type="password" placeholder="Password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" required autocomplete="new-password">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-lock"></span>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="input-group mb-3">
                                <input id="password-confirm" type="password" placeholder="Retype password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-lock"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="row justify-content-center mb-4">
                                <div class="col-4">
                                    <button type="submit" class="btn btn-primary btn-block">Register</button>
                                </div>
                            </div>
                        </form>

                        <a href="/login" class="text-center">I already have an account</a>
                    </div>

                </div>
            </div>
        <?php endif; ?>



    <?php else: ?>

        <div class="wrapper">
            <nav class="main-header navbar navbar-expand navbar-white navbar-light">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                    </li>
                </ul>


                <ul class="navbar-nav ml-auto">


                    <li class="nav-item">
                        <a class="nav-link" data-widget="fullscreen" href="#" role="button">
                            <i class="fas fa-expand-arrows-alt"></i>
                        </a>
                    </li>
                </ul>
            </nav>

            <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <a href="#" class="brand-link">
                <img src="<?php echo e(asset('dist/svg-files/pgno_logo.svg')); ?>" alt="pgno-log" class="brand-image img-circle elevation-3">
                <span class="brand-text font-weight-light">ONE HOSPITAL</span>
            </a>
            <div class="sidebar">
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <img src="<?php echo e(asset('dist/svg-files/user-avatar.svg')); ?>" class="img-circle elevation-2" alt="User Image">
                    </div>
                    <div class="info">
                        <a href="/profile" class="d-block text-capitalize"><?php echo e(Auth::user()->fname); ?> <?php echo e(Auth::user()->lname); ?></a>
                    </div>
                </div>

                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">

                        <?php if(Auth::user()->role != 1 && Auth::user()->role != 4): ?>
                            <li class="nav-item">
                                <a href="/dashboard" class="nav-link <?php if($page == 'dashboard.index'): ?> active <?php endif; ?>">
                                    <i class="nav-icon fas fa-tachometer-alt"></i>
                                    <p>Dashboard</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <li class="nav-item">
                            <a href="/referrals" class="nav-link <?php if($page == ''): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-address-card"></i>
                                <p>Referrals</p>
                            </a>
                        </li>

                        <?php if(Auth::user()->role == 1): ?>
                            <li class="nav-item">
                                <a href="/patients" class="nav-link <?php if($page == 'patient.index'): ?> active <?php endif; ?>">
                                    <i class="nav-icon fas fa-procedures"></i>
                                    <p>Patients</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Auth::user()->role != 4): ?>
                            <?php if(Auth::user()->role != 1): ?>
                                <li class="nav-item">
                                    <a href="/hospitals" class="nav-link <?php if($page == ''): ?> active <?php endif; ?>">
                                        <i class="nav-icon fas fa-h-square"></i>
                                        <p>Hospitals</p>
                                    </a>
                                </li>

                                <li class="nav-item">
                                    <a href="/drrmos" class="nav-link <?php if($page == ''): ?> active <?php endif; ?>">
                                        <i class="nav-icon fas fa-briefcase-medical"></i>
                                        <p>City/Municipality</p>
                                    </a>
                                </li>
                            <?php else: ?>
                                <li class="nav-item">
                                    <a href="/hospital/<?php echo e(Auth::user()->hospital_id); ?>" class="nav-link <?php if($page == ''): ?> active <?php endif; ?>">
                                        <i class="nav-icon fas fa-h-square"></i>
                                        <p>Facility</p>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if(Auth::user()->role == 3): ?>
                            <li class="nav-item">
                                <a href="/statistics/admin" class="nav-link <?php if($page == 'statistics'): ?> active <?php endif; ?>">
                                    <i class="nav-icon fas fa-file-medical-alt"></i>
                                    <p>Statictics</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Auth::user()->role == 2): ?>
                            <li class="nav-item">
                                <a href="/statistics/hod" class="nav-link <?php if($page == 'statistics_hod'): ?> active <?php endif; ?>">
                                    <i class="nav-icon fas fa-file-medical-alt"></i>
                                    <p>Statictics</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Auth::user()->role == 4): ?>
                            <li class="nav-item">
                                <a href="/statistics/lgu" class="nav-link <?php if($page == 'statistics_hod'): ?> active <?php endif; ?>">
                                    <i class="nav-icon fas fa-file-medical-alt"></i>
                                    <p>Statictics</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Auth::user()->role == 1): ?>
                            <li class="nav-item">
                                <a href="/statistics/hospital" class="nav-link <?php if($page == 'statistics_h'): ?> active <?php endif; ?>">
                                    <i class="nav-icon fas fa-file-medical-alt"></i>
                                    <p>Statictics</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <li class="nav-header">SYSTEM SETTINGS</li>

                        <li class="nav-item">
                            <?php if(Auth::user()->role == 3): ?>
                                <a href="/notifications" class="nav-link <?php if($page == 'all_notifications'): ?> active <?php endif; ?>">
                            <?php elseif(Auth::user()->role == 2): ?>
                                <a href="/notifications-hod" class="nav-link <?php if($page == 'hod_notifications'): ?> active <?php endif; ?>">
                            <?php elseif(Auth::user()->role == 1): ?>
                                <a href="/notifications-h" class="nav-link <?php if($page == 'hospital_notifications'): ?> active <?php endif; ?>">
                            <?php elseif(Auth::user()->role == 4): ?>
                                <a href="/notifications-d" class="nav-link <?php if($page == 'drrmo_notifications'): ?> active <?php endif; ?>">
                            <?php endif; ?>
                                <i class="nav-icon far fa-bell"></i>
                                <p>
                                Notifications


                                    <?php if(isset($notifs)): ?>
                                        <?php if(count($notifs)): ?>
                                            <span class="badge badge-warning right" id="notif-ctr"> <?php echo e(count($notifs)); ?> </span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="badge badge-warning right" id="notif-ctr"></span>
                                    <?php endif; ?>


                                </p>
                            </a>
                        </li>

                        <?php if(Auth::user()->role == 3): ?>

                            <li class="nav-item">
                                <a href="/users" class="nav-link <?php if($page == 'user.index' || $page == 'user.show'): ?> active <?php endif; ?>">
                                    <i class="nav-icon fa fa-users"></i>
                                    <p>
                                    Users
                                    </p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="/users/pass-reset" class="nav-link <?php if($page == 'password_reset.index'): ?> active <?php endif; ?>">
                                    <i class="nav-icon fa fa-user-lock"></i>
                                    <p>
                                    User Password Reset
                                    </p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('logout')); ?>"
                                onclick="event.preventDefault();
                                          document.getElementById('logout-form').submit();">
                                <i class="nav-icon fa fa-power-off"></i>
                                <p>
                                Logout
                                </p>
                            </a>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>

                    </ul>
                </nav>
            </div>
            </aside>

            <div class="content-wrapper">
                <section class="content-header">
                    <div class="container-fluid">

                        <?php echo $__env->yieldContent('bread-crumb'); ?>

                    </div>
                </section>

                <section class="content">

                    <?php echo $__env->yieldContent('content'); ?>

                </section>
            </div>

            <footer class="main-footer">
                <div class="float-right d-none d-sm-block">
                    
                </div>
                Copyright &copy; 2021 Negros Occidental - Provincial Administrator's Office.
            </footer>

            <aside class="control-sidebar control-sidebar-dark">
            </aside>
        </div>

    <?php endif; ?>
    </div>

    <!-- jQuery -->
    <script src=" <?php echo e(asset('plugins/jquery/jquery.min.js')); ?> "></script>
    <!-- Bootstrap 4 -->
    <script src=" <?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?> "></script>
    <!-- pace-progress -->
    <script src=" <?php echo e(asset('plugins/pace-progress/pace.min.js')); ?> "></script>

    <script src="<?php echo e(asset('plugins/dropzone/min/dropzone.min.js')); ?>"></script>

    <?php if(
            $page == 'hospital.show' || $page == 'hospital.index' ||
            $page == 'drrmo.show' || $page == 'drrmo.index' ||
            $page == 'patient.index' ||
            $page == 'doctor.create' ||
            $page == 'user.index' || $page == 'user.show' ||
            $page == 'referral.create' || $page == 'referral.show' || $page == 'referral.index' || $page == 'referral.search' ||
            $page == 'referral.on-process' || $page == 'referral.done' || $page == 'referral.incoming' ||
            $page == 'ambulance.dispatch_ambu'

        ): ?>
        <script src=" <?php echo e(asset('plugins/datatables/jquery.dataTables.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/jszip/jszip.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/pdfmake/pdfmake.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/pdfmake/vfs_fonts.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/buttons.html5.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/buttons.print.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/buttons.colVis.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/bootstrap-switch/js/bootstrap-switch.min.js')); ?> "></script>

        <!-- Select2 -->
        <script src=" <?php echo e(asset('plugins/select2/js/select2.full.min.js')); ?> "></script>
    <?php endif; ?>

    <?php if($page == 'dashboard.index' || $page == 'statistics' || $page == 'statistics_hod'): ?>
    
        <script src=" <?php echo e(asset('canvasjs-3.4.2/jquery.canvasjs.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('canvasjs-3.4.2/canvasjs.min.js')); ?> "></script>

        <script src=" <?php echo e(asset('plugins/chart.js/Chart.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables/jquery.dataTables.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/buttons.html5.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/buttons.print.min.js')); ?> "></script>
        <script src=" <?php echo e(asset('plugins/datatables-buttons/js/buttons.colVis.min.js')); ?> "></script>


    <?php endif; ?>


    <!-- AdminLTE App -->
    <script src=" <?php echo e(asset('dist/js/adminlte.min.js')); ?> "></script>
    <!-- AdminLTE for demo purposes -->
    <script src=" <?php echo e(asset('dist/js/demo.js')); ?> "></script>

    <!-- Scripts -->

    <?php if($page == 'referral.create' || $page == 'referral.direct_refer'): ?>

        <script>
            $('#birthdate').change(function() {
                dob = new Date($(this).val());
                var today = new Date();
                if(dob<today) {
                    var age = Math.floor((today-dob) / (365.25 * 24 * 60 * 60 * 1000));
                    if(age > 0) {
                        $('#age').val(age+' y.o');
                    } else {
                        var dob_m = dob.getMonth() + 1, tod_m = today.getMonth() + 1
                        age = tod_m - dob_m

                        if(age > 0) {
                            $('#age').val(age+' m.o')
                        } else {
                            var tod_d = today.getDate(), dob_d = dob.getDate()
                            age = tod_d - dob_d
                            $('#age').val(age+' d.o')
                        }
                    }
                }
            })
        </script>

    <?php endif; ?>

    <?php if(auth()->guard()->check()): ?>
        <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
        <?php if(Auth::user()->role == 2): ?>
            <script src="<?php echo e(asset('js/hod-head-pusher-config.js')); ?>" defer></script>
        <?php elseif(Auth::user()->role == 1): ?>
            <script>
                let hospital_id = "<?php echo e(Auth::user()->hospital_id); ?>"
            </script>
            <script src="<?php echo e(asset('js/hospital-pusher-config.js')); ?>" defer></script>
        <?php elseif(Auth::user()->role == 4): ?>
            <script>
                let drrmo_id = "<?php echo e(Auth::user()->drrmo_id); ?>"
            </script>
            <script src="<?php echo e(asset('js/drrmo-pusher-config.js')); ?>" defer></script>
        <?php endif; ?>
    <?php endif; ?>

    <?php echo $__env->yieldContent('script'); ?>
</body>
</html>
<?php /**PATH /home/misnegros/public_html/staging-onehospital/resources/views/layouts/app.blade.php ENDPATH**/ ?>