@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Users</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Users</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card">
    <div class="card-header ">
        <h3 class="card-title text-uppercase">Assign a User </h3>
        <small>
            <span class="float-right font-italic text-muted"><b>Note:</b> Assigned user will automatically activated and can already login to the system.</span>
        </small>
    </div>
    <div class="card-body">
        <form class="form-horizontal" action="/user/assign" method="POST">
            @csrf
            <div class="card-body">
                <div class="form-group row">
                    <label for="user_id" class="col-sm-2 col-form-label">User *</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" style="width: 100%;" name="user_id" required>
                            <option selected="selected" value="">Please select a user</option>
                            @forelse ($unassigned_users as $item)
                                @if ($item->id != Auth::user()->id)
                                    <option value="{{$item->id}}">{{ucfirst($item->fname)}} {{ucfirst($item->lname)}}</option>
                                @endif
                            @empty
                                <option>Sorry, no user found.</option>
                            @endforelse
                        </select>
                        @error('user_id')
                            <span>
                                User already assigned.
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label for="hospital_id" class="col-sm-2 col-form-label">Hospital</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" style="width: 100%;" name="hospital_id">
                            <option selected="selected" value="">Please select a hospital</option>
                            @forelse ($hospitals as $item)
                                <option value="{{$item->id}}">{{ucwords($item->hospital)}}</option>
                            @empty
                                <option>Sorry, no hospital found.</option>
                            @endforelse
                        </select>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="hospital_id" class="col-sm-2 col-form-label">City/Municipality Office</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" style="width: 100%;" name="drrmo_id">
                            <option selected="selected" value="">Please select a DRRMO</option>
                            @forelse ($drrmos as $item)
                                <option value="{{$item->id}}">{{ucwords($item->drrmo)}}</option>
                            @empty
                                <option>Sorry, no DRRMO found.</option>
                            @endforelse
                        </select>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="role" class="col-sm-2 col-form-label">Role *</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" style="width: 100%;" name="role" required>
                            <option selected="selected" value="">Please select a role</option>
                            <option value="3">Super Admin</option>
                            <option value="2">HOD Head</option>
                            <option value="1">Hospital</option>
                            <option value="4">City/Municipality Office</option>
                        </select>
                    </div>
                </div>

                @if (session()->has('assigned_user.store'))
                    @if (session()->get('assigned_user.store'))
                        <div class="row">
                            <div class="alert alert-success alert-dismissible col-12" id="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <h5><i class="icon fas fa-check"></i> Success!</h5>
                                User successfully assigned!
                            </div>
                        </div>
                    @endif
                @endif
            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>
                     SAVE
                </button>
            </div>
        </form>
    </div>

</div>


<div class="card">
    <div class="card-header">
      <h3 class="card-title">Data as of [<span class="text-muted font-italic">{{date('Y-m-d')}}</span>]</h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
      <table id="example1" class="table table-hover text-nowrap">
        <thead>
            <tr>
                <th>User</th>
                <th>Email</th>
                <th>Status</th>
                <th>Role</th>
                <th>Date Registered</th>
                <th></th>
            </tr>
        </thead>
        <tbody>


            @foreach ($users as $item)
                <?php $role='-' ?>
                @if ($item->assigned_user != null)
                    @if ($item->assigned_user->role == 2)
                        <?php $role = 'HOD Head' ?>
                    @elseif($item->assigned_user->role == 1)
                        <?php $role = 'Hospital' ?>
                    @elseif($item->assigned_user->role == 3)
                        <?php $role = 'Super Admin' ?>
                    @elseif($item->assigned_user->role == 4)
                        <?php $role = 'DRRMO' ?>
                    @endif
                @endif
                <tr>
                    <td class="text-capitalize"> {{$item->fname}} {{$item->lname}} @if(Auth::user()->id == $item->id) <small>(You)</small> @endif</td>
                    <td> {{$item->email}} </td>
                    <td> {{$item->active == 1 ? 'active' : 'inactive'}} </td>
                    <td> {{$role}} </td>
                    <td> {{$item->created_at}} </td>
                    <td>
                        <a href="/user/{{$item->id}}">
                            <i class="fa fa-folder"></i>
                        </a>
                    </td>
                </tr>
            @endforeach

        </tbody>
        <tfoot>
            <tr>
                <th>User</th>
                <th>Email</th>
                <th>Status</th>
                <th>Role & Designation</th>
                <th>Date Registered</th>
                <th></th>
            </tr>
        </tfoot>
      </table>
    </div>
    <!-- /.card-body -->
</div>
  <!-- /.card -->
@endsection

@section('script')
    <script>
        $(function () {
            $("#example1").DataTable({
                "responsive": true, "lengthChange": false, "autoWidth": false,
                "buttons": ["colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
            //Initialize Select2 Elements
            $('.select2').select2()
        });
    </script>
@endsection
