@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Station</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Create Station</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/{{$hospital->id}}" class="btn btn-sm btn-success rounded-0" title="Return to {{$hospital->hospital}} dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <form class="form-horizontal" action="/hospital/station" method="POST">
            @csrf
            @isset($station)
                @method('PUT')
                <input type="hidden" name="id" value="{{$station->id}}">
            @endisset
            <div class="card-body">
                <div class="form-group row">
                    <label for="inputEmail3" class="col-sm-2 col-form-label">Hospital *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" value="{{$hospital->hospital}}" readonly>
                        <input type="hidden" class="form-control" id="hospital_id" name="hospital_id" value="{{$hospital->id}}">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="inputPassword3" class="col-sm-2 col-form-label">Station *</label>
                    <div class="col-sm-10">
                        @isset($station)
                            <input type="text" class="form-control" id="station" name="station" value="{{$station->station}}" required>
                        @else
                            <input type="text" class="form-control" id="station" name="station" placeholder="-" required>
                            @error('station')
                                <span>
                                    {{ $message }}
                                </span>
                            @enderror
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label for="inputPassword3" class="col-sm-2 col-form-label">Description</label>
                    <div class="col-sm-10">
                        @isset($station)
                            <input type="text" class="form-control" id="description" name="description" value="{{$station->description}}">
                        @else
                            <input type="text" class="form-control" id="description" name="description" placeholder="-">
                            @error('description')
                                <span>
                                    {{ $message }}
                                </span>
                            @enderror
                        @endisset
                    </div>
                </div>
            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>
                     SAVE
                </button>
            </div>
        </form>
        @if (session()->has('station.store') || session()->has('station.update') || session()->has('station.destroy'))
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                @if (session()->get('station.store'))
                    New station successfully added!
                @elseif(session()->get('station.update'))
                    Update Successful!
                @elseif(session()->get('station.destroy'))
                    Delete Successful!
                @endif
            </div>
        @endif
    </div>
    <hr>

    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Station</th>
                    <th>Description</th>
                    <th>Created at</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($stations as $item)
                    <tr>
                        <td>{{$item->station}}</td>
                        <td>{{$item->description}}</td>
                        <td>{{$item->created_at}}</td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/hospital/{{$item->hospital_id}}/station?id={{$item->id}}" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/station" method="post">
                                    @csrf
                                    @method('DELETE')
                                    <input type="hidden" name="del_station_id" value="{{$item->id}}">
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No beds found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
