@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>{{$hospital->hospital}}</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item active">{{$hospital->hospital}}</li>
            </ol>
        </div>
    </div>
@endsection

@section('content')

<div class="card card-widget widget-user">
    <div class="widget-user-header bg-success">
        <h3 class="widget-user-username">{{$hospital->hospital}}</h3>
        <h5 class="widget-user-desc">{{$hospital->address}}</h5>
    </div>
    <div class="widget-user-image">
        <img class="img-circle elevation-2" src=" {{asset('dist/svg-files/pgno_logo.svg')}} " alt="User Avatar">
    </div>
    <div class="card-footer">
        <div class="row">
            <div class="col-sm-3 border-right">
                <div class="description-block">
                    <h5 class="description-header">{{count($stations)}}</h5>
                    <span class="description-text">STATIONS</span>
                </div>
            </div>
            <div class="col-sm-3 border-right">
                <div class="description-block">
                    <h5 class="description-header">{{count($rooms)}}</h5>
                    <span class="description-text">ROOMS</span>
                </div>
            </div>
            <div class="col-sm-3 border-right">
                <div class="description-block">
                    <h5 class="description-header">{{count($beds)}}</h5>
                    <span class="description-text">BEDS</span>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="description-block">
                    <h5 class="description-header">
                        <?php $ctr=0 ?>
                        @foreach ($beds as $item)
                            @if ($item->status == 1)
                                <?php $ctr++ ?>
                            @endif
                        @endforeach
                        {{$ctr}}
                    </h5>
                    <span class="description-text">AVAILABLE</span>
                </div>
            </div>


        </div>
    </div>
</div>

<div class="card card-default">
    <div class="card-header">
      <h3 class="card-title">
        Ambulance Status
      </h3>
    </div>
    <div class="card-body">

        {{-- @if (Auth::user()->role == 1 || Auth::user()->role == 2) --}}
        <div class="row">
            <div class="col-12">

                @if (Auth::user()->role == 1)
                    <a href="/ambulance/create?hospital_id={{$hospital->id}}" class="btn btn-sm btn-secondary rounded-0">
                        <i class="fa fa-plus"></i> AMBULANCE
                    </a>

                    <button class="btn btn-sm btn-warning rounded-0" data-toggle="modal" data-target="#modal-ambulance">
                        <i class="fa fa-file"></i> UPDATE LIST
                    </button>

                    <!-- ambulance update list modal -->
                    <div class="modal fade" id="modal-ambulance">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <form action="/ambulance/list" method="post">
                                    @csrf
                                    @method('PUT')
                                    <input type="hidden" name="hospital_id" value="{{$hospital->id}}">
                                    <div class="modal-header">
                                        <h4 class="modal-title">UPDATE AMBULANCE AVAILABILITY</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="card-body table-responsive p-0">
                                            <table class="table text-nowrap">
                                                <thead>
                                                    <tr>
                                                        <th>Ambulance</th>
                                                        <th>Driver</th>
                                                        <th>Crew</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse ($ambulances as $item)
                                                        <tr>
                                                            <td>{{$item->ambulance}}</td>
                                                            <td>{{$item->driver}}</td>
                                                            <td>{{$item->crew}}</td>
                                                            <td>
                                                                <input type="checkbox" name="status[]" value="{{$item->id}}" @if($item->status) checked @endif data-bootstrap-switch data-off-color="danger" data-on-color="success">
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="4" class="text-center">No data available.</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                            </div>
                                    </div>
                                    <div class="modal-footer justify-content-center">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-success">Save changes</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- ambulance update list modal -->
                @endif

                <a href="/ambulance/dispatch?hospital_id={{$hospital->id}}" class="btn btn-sm btn-danger rounded-0">
                    <i class="fa fa-ambulance"></i> DISPATCH
                </a>
            </div>
        </div>
        <hr>


        <div class="row">
            @forelse ($ambulances as $item)
                <div class="col-sm-6 col-md-3 col-lg-2 col-12 @if($item->status) bg-success @else bg-danger @endif rounded p-3 mb-2">
                    <div class="row mb-2">
                        <div class="col-4 d-flex">
                            @if ($item->status)
                                <img class="w-100 align-self-center border" style="border-radius: 50%" src="{{asset('dist/icons/ambulance.png')}}" alt="" srcset="">
                            @else
                                <img class="w-100 align-self-center border" style="border-radius: 50%" src="{{asset('dist/icons/incomingambulance.gif')}}" alt="" srcset="">
                            @endif
                        </div>
                        <div class="col-8">
                            <small class="m-0 text-uppercase">{{$item->ambulance}}</small>
                            <br><small class="m-0">{{ $item->status ? 'Available' : 'Occupied' }}</small>
                            <br><small class="m-0">Driver: {{$item->driver}}</small>
                            <br><small class="m-0">Crew: {{$item->crew}}</small>
                        </div>
                    </div>

                    @if (Auth::user()->role == 1)
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <a href="/ambulance/edit/{{$item->id}}" class="btn btn-block btn-sm btn-default rounded-0">
                                    <i class="fa fa-edit"></i>
                                </a>
                            </div>
                            <div class="col-md-6 col-12">
                                <button class="btn btn-block btn-sm btn-default rounded-0 text-danger" data-toggle="modal" data-target="#modal-ambulance{{$item->id}}-delete">
                                    <i class="fa fa-trash"></i>
                                </button>
                                <!-- delete ambulance modal -->
                                <div class="modal fade" id="modal-ambulance{{$item->id}}-delete">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title text-dark">Delete Confirmation</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body text-dark">
                                                    <div class="row @if($item->status) bg-success @else bg-danger @endif rounded p-3 mb-2">
                                                        <div class="col-4 d-flex">
                                                            @if ($item->status)
                                                                <img class="w-75 align-self-center border" style="border-radius: 50%" src="{{asset('dist/icons/ambulance.png')}}" alt="" srcset="">
                                                            @else
                                                                <img class="w-75 align-self-center border" style="border-radius: 50%" src="{{asset('dist/icons/incomingambulance.gif')}}" alt="" srcset="">
                                                            @endif
                                                        </div>
                                                        <div class="col-8">
                                                            <small class="m-0 text-uppercase">{{$item->ambulance}}</small>
                                                            <br><small class="m-0">{{ $item->status ? 'Available' : 'Occupied' }}</small>
                                                            <br><small class="m-0">Driver: {{$item->driver}}</small>
                                                            <br><small class="m-0">Crew: {{$item->crew}}</small>
                                                        </div>
                                                    </div>
                                            </div>
                                            <div class="modal-footer justify-content-center">
                                                <form action="/ambulance" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input type="hidden" name="ambulance_id" value="{{$item->id}}">
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-danger">Delete Ambulance</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- delete ambulance modal -->
                            </div>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-12">
                            @if ($item->ref_id)
                                <a href="/referral/{{$item->ref_id}}" class="btn btn-sm btn-default btn-block rounded-0 mt-3">REF # {{$item->ref_no}}</a>
                            @else
                                <small class="font-italic">Last update: </small> <small>{{$item->latest_update}}</small>
                            @endif
                        </div>
                    </div>
                </div>&nbsp;
                @empty
                    <div class="col-12 text-center">
                        <h3 class="text-muted">No available ambulance.</h3>
                    </div>
            @endforelse
        </div>
    </div>
</div>

<div class="card card-success card-outline card-tabs">
    <div class="card-body">

        @if (Auth::user()->role == 1)
            <div class="row">
                <div class="col-12 mb-3">
                    <a href="/doctor/create?hospital_id={{$hospital->id}}" class="btn btn-sm btn-success rounded-0">
                        <i class="fa fa-plus"></i> Doctor
                    </a>
                    <a href="/department/create?hospital_id={{$hospital->id}}" class="btn btn-sm btn-secondary rounded-0">
                        <i class="fa fa-plus"></i> BED
                    </a>
                    <a href="/doctor-sched/create?hospital_id={{$hospital->id}}" class="btn btn-sm btn-warning rounded-0">
                        <i class="fa fa-calendar" aria-hidden="true"></i> Create Schedule
                    </a>
                </div>
            </div>
        @endif

        <div class="row">

            <div class="col-12 col-md-4 mb-3">
                <div class="card rounded-0">
                    <div class="card-header bg-orange rounded-0">
                        <h5 class="card-title text-uppercase text-white">
                            Emergency Room
                        </h5>
                    </div>

                    <div class="card-body">
                        <!-- EMERGENCY ROOM -->
                        <div class="row">
                            @forelse ($er_beds as $er_item)
                                @if ($er_item->status == 1)
                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">
                                        @isset($referral_id)
                                            @if (Auth::user()->role == 2)
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-dept-bed{{$er_item->id}}-refer">
                                                    <p> {{$er_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                </button>
                                                <div class="modal fade" id="modal-dept-bed{{$er_item->id}}-refer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Bed details: </span> Emergency Room [{{$er_item->bed}}]
                                                                </h4>
                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/referral/finish-referral" method="post">
                                                                    @csrf
                                                                    <input type="hidden" name="ref_no" value="{{$referral_no}}">
                                                                    <input type="hidden" name="dept_bed_id" value="{{$er_item->id}}">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @else

                                        @isset($trans_ref_id)
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-erbed{{$er_item->id}}-transfer">
                                                    <p> {{$er_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                </button>

                                                <div class="modal fade" id="modal-erbed{{$er_item->id}}-transfer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Emergency Room: </span> {{$er_item->bed}}
                                                                </h4>

                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/transfer/{{$trans_ref_id}}" method="post">
                                                                    @csrf
                                                                    @method('PUT')
                                                                    <input type="hidden" name="dept_bed_id" value="{{$er_item->id}}">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            @else
                                                @if (Auth::user()->role == 1)
                                                    <a href="/referral/create?hospital_id={{$er_item->hospital_id}}&dept_bed_id={{$er_item->id}}&internal=true">
                                                @else
                                                    <a href="/referral/create?hospital_id={{$er_item->hospital_id}}&dept_bed_id={{$er_item->id}}">
                                                @endif
                                                    <p> {{$er_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" >
                                                </a>
                                            @endisset
                                        @endisset
                                    </div>&nbsp;
                                @else
                                    <div class="col-2 @if($er_item->status == 2) bg-warning @else bg-danger @endif text-white text-center p-2 rounded mb-2 @if(request()->get('dbed') == $er_item->id) glowing-circle mx-3 @endif" id="dbed{{$er_item->id}}">

                                        <a href="/referral/{{$er_item->ref_id}}" target="_blank" rel="noopener noreferrer">

                                            <p> {{$er_item->bed}} </p>
                                            @if($er_item->status == 2)
                                                <img class="w-100" src="{{asset('dist/icons/incoming.gif')}}" >
                                            @elseif($er_item->status == 3)
                                                <img class="w-100" src="{{asset('dist/icons/occupiedbed.png')}}" >
                                            @endif

                                            @isset ($er_item->ref_no)
                                                <small>REF # {{$er_item->ref_no}}</small>
                                            @endisset

                                        </a>

                                    </div>&nbsp;
                                @endif
                            @empty
                                <p class="text-center text-muted p-0 m-0">
                                    No beds found.
                                </p>
                            @endforelse
                        </div>
                        <!-- EMERGENCY ROOM -->
                        <hr>
                        <div class="row">
                            @forelse ($er_doctors as $erdr_item)
                                <div class="col-12 bg-gray p-2 pl-3 rounded mb-2">
                                    <div class="d-flex">
                                        <img class="w-25 h-25" src="{{asset('dist/icons/doctor.png')}}" alt="" srcset="">
                                        <h5 class="align-self-center p-0 m-0 ml-2">
                                            {{$erdr_item->doctor}} <small class="font-italic">[ {{$erdr_item->specialty}} ] [ {{$erdr_item->remarks}} ]</small>
                                        </h5>
                                    </div>
                                    <?php $in=date_create($erdr_item->in); $out=date_create($erdr_item->out);  ?>
                                    <small class="p-0 m-0 float-right">  {{date_format($in,"g:i A")}} - {{date_format($out,"g:i A")}}</small>
                                </div>
                            @empty
                                <p class="text-center text-muted p-0 m-0">
                                    No schedule of doctors found for this month.
                                </p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 mb-3">
                <div class="card rounded-0">
                    <div class="card-header rounded-0 bg-success">
                        <h5 class="card-title text-uppercase text-white">
                            Operating Room
                        </h5>
                    </div>

                    <div class="card-body">
                        <!-- OPERATING ROOM -->
                        <div class="row">
                            @forelse ($or_beds as $or_item)
                                @if ($or_item->status == 1)
                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">
                                        @isset($referral_id)
                                            @if (Auth::user()->role == 2)
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-dept-bed{{$or_item->id}}-refer">
                                                    <p> {{$or_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                </button>
                                                <div class="modal fade" id="modal-dept-bed{{$or_item->id}}-refer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Bed details: </span> Emergency Room [{{$or_item->bed}}]
                                                                </h4>
                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/referral/finish-referral" method="post">
                                                                    @csrf
                                                                    <input type="hidden" name="ref_no" value="{{$referral_no}}">
                                                                    <input type="hidden" name="dept_bed_id" value="{{$or_item->id}}">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @else

                                            @isset($trans_ref_id)
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-orbed{{$or_item->id}}-transfer">
                                                    <p> {{$or_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                </button>

                                                <div class="modal fade" id="modal-orbed{{$or_item->id}}-transfer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Delivery Room: </span> {{$or_item->bed}}
                                                                </h4>

                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/transfer/{{$trans_ref_id}}" method="post">
                                                                    @csrf
                                                                    @method('PUT')
                                                                    <input type="hidden" name="dept_bed_id" value="{{$or_item->id}}">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            @else
                                                @if (Auth::user()->role == 1)
                                                    <a href="/referral/create?hospital_id={{$or_item->hospital_id}}&dept_bed_id={{$or_item->id}}&internal=true">
                                                @else
                                                    <a href="/referral/create?hospital_id={{$or_item->hospital_id}}&dept_bed_id={{$or_item->id}}">
                                                @endif

                                                    <p> {{$or_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" >


                                                    </a>
                                            @endisset

                                        @endisset
                                    </div>&nbsp;
                                @else
                                    <div class="col-2 @if($or_item->status == 2) bg-warning @else bg-danger @endif text-white text-center p-2 rounded mb-2  @if(request()->get('dbed') == $or_item->id) glowing-circle mx-3 @endif" id="dbed{{$or_item->id}}">

                                        <a href="/referral/{{$or_item->ref_id}}" target="_blank" rel="noopener noreferrer">

                                            <p> {{$or_item->bed}} </p>
                                            @if($or_item->status == 2)
                                                <img class="w-100" src="{{asset('dist/icons/incoming.gif')}}" >
                                            @elseif($or_item->status == 3)
                                                <img class="w-100" src="{{asset('dist/icons/occupiedbed.png')}}" >
                                            @endif

                                            @isset ($or_item->ref_no)
                                                <small>REF # {{$or_item->ref_no}}</small>
                                            @endisset


                                        </a>

                                    </div>&nbsp;
                                @endif
                            @empty
                                <p class="text-center text-muted p-0 m-0">
                                    No beds found.
                                </p>
                            @endforelse
                        </div>
                        <!-- OPERATING ROOM -->
                        <hr>
                        <div class="row">
                            @forelse ($or_doctors as $ordr_item)
                                <div class="col-12 bg-gray p-2 pl-3 rounded mb-2">
                                    <div class="d-flex">
                                        <img class="w-25 h-25" src="{{asset('dist/icons/doctor.png')}}" alt="" srcset="">
                                        <h5 class="align-self-center p-0 m-0 ml-2">
                                            {{$ordr_item->doctor}} <small class="font-italic">[ {{$ordr_item->specialty}} ] [ {{$ordr_item->remarks}} ]</small>
                                        </h5>
                                    </div>
                                    <?php $in=date_create($ordr_item->in); $out=date_create($ordr_item->out);  ?>
                                    <small class="p-0 m-0 float-right">  {{date_format($in,"g:i A")}} - {{date_format($out,"g:i A")}}</small>
                                </div>

                            @empty
                                <p class="text-center text-muted p-0 m-0">
                                    No schedule of doctors found for this month.
                                </p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 mb-3">
                <div class="card rounded-0">
                    <div class="card-header bg-info rounded-0">
                        <h5 class="card-title text-uppercase text-white">
                            Delivery Room
                        </h5>
                    </div>

                    <div class="card-body">
                        <!-- DELIVERY ROOM -->
                        <div class="row">
                            @forelse ($dr_beds as $dr_item)
                                @if ($dr_item->status == 1)
                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">
                                        @isset($referral_id)
                                            @if (Auth::user()->role == 2)
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-dept-bed{{$dr_item->id}}-refer">
                                                    <p> {{$dr_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                </button>
                                                <div class="modal fade" id="modal-dept-bed{{$dr_item->id}}-refer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Bed details: </span> Emergency Room [{{$dr_item->bed}}]
                                                                </h4>
                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/referral/finish-referral" method="post">
                                                                    @csrf
                                                                    <input type="hidden" name="ref_no" value="{{$referral_no}}">
                                                                    <input type="hidden" name="dept_bed_id" value="{{$dr_item->id}}">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @else

                                            @isset($trans_ref_id)
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-drbed{{$dr_item->id}}-transfer">
                                                    <p> {{$dr_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                </button>

                                                <div class="modal fade" id="modal-drbed{{$dr_item->id}}-transfer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Delivery Room: </span> {{$dr_item->bed}}
                                                                </h4>

                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/transfer/{{$trans_ref_id}}" method="post">
                                                                    @csrf
                                                                    @method('PUT')
                                                                    <input type="hidden" name="dept_bed_id" value="{{$dr_item->id}}">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @else
                                                @if (Auth::user()->role == 1)
                                                    <a href="/referral/create?hospital_id={{$dr_item->hospital_id}}&dept_bed_id={{$dr_item->id}}&internal=true">
                                                @else
                                                    <a href="/referral/create?hospital_id={{$dr_item->hospital_id}}&dept_bed_id={{$dr_item->id}}">
                                                @endif

                                                    <p> {{$dr_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" >

                                                </a>
                                            @endisset

                                        @endisset



                                    </div>&nbsp;
                                @else
                                    <div class="col-2 @if($dr_item->status == 2) bg-warning @else bg-danger @endif text-white text-center p-2 rounded mb-2  @if(request()->get('dbed') == $dr_item->id) glowing-circle mx-3 @endif" id="dbed{{$dr_item->id}}">


                                        <a href="/referral/{{$dr_item->ref_id}}" target="_blank" rel="noopener noreferrer">

                                            <p> {{$dr_item->bed}} </p>
                                            @if($dr_item->status == 2)
                                                <img class="w-100" src="{{asset('dist/icons/incoming.gif')}}" >
                                            @elseif($dr_item->status == 3)
                                                <img class="w-100" src="{{asset('dist/icons/occupiedbed.png')}}" >
                                            @endif

                                            @isset ($dr_item->ref_no)
                                                <small>REF # {{$dr_item->ref_no}}</small>
                                            @endisset

                                        </a>


                                    </div>&nbsp;
                                @endif
                            @empty
                                <p class="text-center text-muted p-0 m-0">
                                    No beds found.
                                </p>
                            @endforelse
                        </div>
                        <!-- DELIVERY ROOM -->
                        <hr>
                        <div class="row">
                            @forelse ($dr_doctors as $drdr_item)
                                <div class="col-12 bg-gray p-2 pl-3 rounded mb-2">
                                    <div class="d-flex">
                                        <img class="w-25 h-25" src="{{asset('dist/icons/doctor.png')}}" alt="" srcset="">
                                        <h5 class="align-self-center p-0 m-0 ml-2">
                                            {{$drdr_item->doctor}} <small class="font-italic">[ {{$drdr_item->specialty}} ] [ {{$drdr_item->remarks}} ]</small>
                                        </h5>
                                    </div>
                                    <?php $in=date_create($drdr_item->in); $out=date_create($drdr_item->out);  ?>
                                    <small class="p-0 m-0 float-right">  {{date_format($in,"g:i A")}} - {{date_format($out,"g:i A")}}</small>
                                </div>
                            @empty
                                <p class="text-center text-muted p-0 m-0">
                                    No schedule of doctors found for this month.
                                </p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>

            <!-- OPD -->
            <div class="col-12 col-md-4 mb-3">
                <div class="card rounded-0">
                    <div class="card-header bg-primary rounded-0">
                        <h5 class="card-title text-uppercase text-white">
                            OUTPATIENT DEPARTMENT
                        </h5>
                    </div>

                    <div class="card-body">
                        <!-- OUTPATIENT DEPARTMENT -->
                        <div class="row">
                            @forelse ($opd_beds as $opd_item)
                                @if ($opd_item->status == 1)
                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">
                                        @isset($referral_id)
                                            @if (Auth::user()->role == 2)
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-dept-bed{{$opd_item->id}}-refer">
                                                    <p> {{$opd_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                </button>
                                                <div class="modal fade" id="modal-dept-bed{{$opd_item->id}}-refer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Bed details: </span> Outpatient Department [{{$opd_item->bed}}]
                                                                </h4>
                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/referral/finish-referral" method="post">
                                                                    @csrf
                                                                    <input type="hidden" name="ref_no" value="{{$referral_no}}">
                                                                    <input type="hidden" name="dept_bed_id" value="{{$opd_item->id}}">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @else

                                            @isset($trans_ref_id)
                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-opdbed{{$opd_item->id}}-transfer">
                                                    <p> {{$opd_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                </button>

                                                <div class="modal fade" id="modal-opdbed{{$opd_item->id}}-transfer">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">
                                                                <h4 class="nb-3">
                                                                    <span class="text-muted">Outpatient Department: </span> {{$opd_item->bed}}
                                                                </h4>

                                                                <h4 >
                                                                    <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/transfer/{{$trans_ref_id}}" method="post">
                                                                    @csrf
                                                                    @method('PUT')
                                                                    <input type="hidden" name="dept_bed_id" value="{{$opd_item->id}}">
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @else
                                                @if (Auth::user()->role == 1)
                                                    <a href="/referral/create?hospital_id={{$opd_item->hospital_id}}&dept_bed_id={{$opd_item->id}}&internal=true">
                                                @else
                                                    <a href="/referral/create?hospital_id={{$opd_item->hospital_id}}&dept_bed_id={{$opd_item->id}}">
                                                @endif

                                                    <p> {{$opd_item->bed}} </p>
                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" >

                                                </a>
                                            @endisset

                                        @endisset



                                    </div>&nbsp;
                                @else
                                    <div class="col-2 @if($opd_item->status == 2) bg-warning @else bg-danger @endif text-white text-center p-2 rounded mb-2  @if(request()->get('dbed') == $opd_item->id) glowing-circle mx-3 @endif" id="dbed{{$opd_item->id}}">


                                        <a href="/referral/{{$opd_item->ref_id}}" target="_blank" rel="noopener noreferrer">

                                            <p> {{$opd_item->bed}} </p>
                                            @if($opd_item->status == 2)
                                                <img class="w-100" src="{{asset('dist/icons/incoming.gif')}}" >
                                            @elseif($opd_item->status == 3)
                                                <img class="w-100" src="{{asset('dist/icons/occupiedbed.png')}}" >
                                            @endif

                                            @isset ($opd_item->ref_no)
                                                <small>REF # {{$opd_item->ref_no}}</small>
                                            @endisset

                                        </a>


                                    </div>&nbsp;
                                @endif
                            @empty
                                <p class="text-center text-muted p-0 m-0">
                                    No beds found.
                                </p>
                            @endforelse
                        </div>
                        <!-- OUTPATIENT DEPARTMENT -->
                        <hr>
                        <div class="row">
                            @forelse ($opd_doctors as $opddr_item)
                                <div class="col-12 bg-gray p-2 pl-3 rounded mb-2">
                                    <div class="d-flex">
                                        <img class="w-25 h-25" src="{{asset('dist/icons/doctor.png')}}" alt="" srcset="">
                                        <h5 class="align-self-center p-0 m-0 ml-2">
                                            {{$opddr_item->doctor}} <small class="font-italic">[ {{$opddr_item->specialty}} ] [ {{$opddr_item->remarks}} ]</small>
                                        </h5>
                                    </div>
                                    <?php $in=date_create($opddr_item->in); $out=date_create($opddr_item->out);  ?>
                                    <small class="p-0 m-0 float-right">  {{date_format($in,"g:i A")}} - {{date_format($out,"g:i A")}}</small>
                                </div>
                            @empty
                                <p class="text-center text-muted p-0 m-0">
                                    No schedule of doctors found for this month.
                                </p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
            <!-- OPD -->
        </div>
    </div>
</div>

@if (Auth::user()->role != 2)
    <a href="/hospital/{{$hospital->id}}/station" class="btn btn-sm rounded-0 btn-secondary mb-3">
        <i class="fa fa-plus"></i> STATION
    </a>
@endif

<div class="card card-success card-outline card-tabs">
    <div class="card-header p-0 pt-1 border-bottom-0">

        <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
            <?php $prev_station1 = ''; $f=true; $tab_ctr=1; ?>
            @forelse ($stations as $item)


                @if (request()->has('station'))
                    <li class="nav-item @if(request()->get('station') == $item->id) active @endif">
                        <a class="nav-link" id="custom-tabs-{{$item->id}}-tab" data-toggle="pill" href="#custom-tabs-{{$item->id}}-home" role="tab" aria-controls="custom-tabs-{{$item->id}}-home" aria-selected="true">
                            {{$item->station}}
                        </a>
                    </li>
                @else
                    @if ($f)
                        <li class="nav-item">
                            <a class="nav-link active" id="custom-tabs-{{$item->id}}-tab" data-toggle="pill" href="#custom-tabs-{{$item->id}}-home" role="tab" aria-controls="custom-tabs-{{$item->id}}-home" aria-selected="true">
                                {{$item->station}}
                            </a>
                        </li>
                        <?php $f=false; ?>
                    @else
                        <li class="nav-item">
                            <a class="nav-link" id="custom-tabs-{{$item->id}}-tab" data-toggle="pill" href="#custom-tabs-{{$item->id}}-home" role="tab" aria-controls="custom-tabs-{{$item->id}}-home" aria-selected="true">
                                {{$item->station}}
                            </a>
                        </li>
                    @endif
                @endif
            @empty
                <!--<h4 class="text-center text-muted">No record found.</h4>-->
            @endforelse
        </ul>
    </div>
    <div class="card-body">
        <div class="tab-content" id="custom-tabs-three-tabContent">
            <?php $prev_station = ''; $f=true; $tab_ctr=1; $ctr=1; ?>

            @forelse ($stations as $item)

                @if (request()->has('station'))
                    <div class="tab-pane fade @if(request()->get('station') == $item->id) active show @endif" id="custom-tabs-{{$item->id}}-home" role="tabpanel" aria-labelledby="custom-tabs-{{$item->id}}-home-tab">
                @else
                    <div class="tab-pane fade @if($f) active show @endif" id="custom-tabs-{{$item->id}}-home" role="tabpanel" aria-labelledby="custom-tabs-{{$item->id}}-home-tab">
                @endif


                    @if (Auth::user()->role != 2)
                        <div class="row">
                            <div class="col-12">
                                <a href="/hospital/{{$item->hospital_id}}/station/{{$item->id}}/room/create" class="btn btn-sm rounded-0 btn-secondary text-center">
                                    <i class="fa fa-plus"></i> ROOM
                                </a>

                                <button class="btn btn-sm rounded-0 btn-danger" data-toggle="modal" data-target="#modal-station{{$item->id}}-delete">
                                    <i class="fa fa-trash"></i> STATION
                                </button>
                                <!-- delete station modal -->
                                <div class="modal fade" id="modal-station{{$item->id}}-delete">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">Delete Confirmation</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body text-center py-4">
                                                <h3>
                                                    <span class="text-muted">Station details: </span> <span class="text-uppercase">{{$item->station}}</span>
                                                </h3>
                                            </div>
                                            <div class="modal-footer justify-content-center">
                                                <form action="/station" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input type="hidden" name="del_station_id" value="{{$item->id}}">
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-danger">Delete Station</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- delete station modal -->
                            </div>
                        </div>
                    @endif

                    <div class="row">
                        @forelse ($rooms as $r_item)
                            @if ($item->id == $r_item->station_id)
                                <div class="col-sm-6 col-md-4 col-12 bg-light mt-3 p-2">
                                    <h5 class="bg-dark mt-3 text-center p-2"> {{$r_item->room}} </h5>
                                    <center>
                                        <span class="text-muted font-italic">{{$r_item->description}}</span>
                                    </center>

                                    @if (Auth::user()->role != 2)
                                        <!-- add bed -->
                                        <div class="row">
                                            <div class="col-12">
                                                <a href="/hospital/{{$r_item->hospital_id}}/station/{{$r_item->station_id}}/room/{{$r_item->id}}/bed/create" class="btn btn-sm rounded-0 btn-secondary mb-3">
                                                    <i class="fa fa-plus"></i> BED
                                                </a>
                                            </div>
                                        </div>
                                        <!-- add bed -->
                                    @endif

                                    <!-- beds container -->
                                    <div class="row p-2 justify-content-center">
                                        @forelse ($beds as $b_item)

                                            @if ($r_item->id == $b_item->room_id)

                                                @if ($b_item->status == 1)
                                                    <div class="col-2 bg-success text-white text-center p-2 rounded mb-2">

                                                        @isset($referral_id)
                                                            <!-- if referral is on going -->
                                                            <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-bed{{$b_item->id}}-refer">
                                                                <p> {{$b_item->bed}} </p>
                                                                <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                            </button>

                                                            <div class="modal fade" id="modal-bed{{$b_item->id}}-refer">
                                                                <div class="modal-dialog">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title text-dark">Refer Confirmation</h4>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-body text-dark">
                                                                            <h4 class="nb-3">
                                                                                <span class="text-muted">Bed details: </span> {{$r_item->room}} - {{$b_item->bed}}
                                                                            </h4>

                                                                            <h4 >
                                                                                <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                            </h4>
                                                                        </div>
                                                                        <div class="modal-footer justify-content-center">
                                                                            <form action="/referral/finish-referral" method="post">
                                                                                @csrf
                                                                                <input type="hidden" name="ref_no" value="{{$referral_no}}">
                                                                                <input type="hidden" name="bed_id" value="{{$b_item->id}}">
                                                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!-- if referral is on going -->
                                                        @else

                                                            @isset($trans_ref_id)
                                                                <button class="btn btn-link text-white" data-toggle="modal" data-target="#modal-bed{{$b_item->id}}-refer">
                                                                    <p> {{$b_item->bed}} </p>
                                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">
                                                                </button>

                                                                <div class="modal fade" id="modal-bed{{$b_item->id}}-refer">
                                                                    <div class="modal-dialog">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h4 class="modal-title text-dark">Transfer Room Confirmation</h4>
                                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                    <span aria-hidden="true">&times;</span>
                                                                                </button>
                                                                            </div>
                                                                            <div class="modal-body text-dark">
                                                                                <h4 class="nb-3">
                                                                                    <span class="text-muted">Bed details: </span> {{$r_item->room}} - {{$b_item->bed}}
                                                                                </h4>

                                                                                <h4 >
                                                                                    <span class="text-muted">Referral no:</span> {{$referral_no}}
                                                                                </h4>
                                                                            </div>
                                                                            <div class="modal-footer justify-content-center">
                                                                                <form action="/transfer/{{$trans_ref_id}}" method="post">
                                                                                    @csrf
                                                                                    @method('PUT')
                                                                                    <input type="hidden" name="bed_id" value="{{$b_item->id}}">
                                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                                                </form>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @else
                                                                @if (Auth::user()->role == 2)
                                                                    <a href="/referral/create?hospital_id={{$b_item->hospital_id}}&bed_id={{$b_item->id}}">
                                                                @else
                                                                    <a href="/referral/create?hospital_id={{$b_item->hospital_id}}&bed_id={{$b_item->id}}&internal=true">
                                                                @endif

                                                                    <p> {{$b_item->bed}} </p>
                                                                    <img class="w-100" src="{{asset('dist/icons/vacantbed.png')}}" alt="" srcset="">

                                                                </a>
                                                            @endisset

                                                        @endisset

                                                    </div>&nbsp;
                                                @else
                                                    <div id="bed{{$b_item->id}}" class="col-2 @if($b_item->status == 2) bg-warning @elseif($b_item->status == 3) bg-danger @endif text-white text-center p-2 rounded mb-2 @if(request()->get('bed') == $b_item->id) glowing-circle mx-3 @endif">
                                                        @if ($b_item->patient_id != null)
                                                            <a href="/patient/{{$b_item->patient_id}}" target="_blank" rel="noopener noreferrer">
                                                                <p> {{$b_item->bed}} </p>

                                                                @if($b_item->status == 2)
                                                                    <img class="w-100" src="{{asset('dist/icons/incoming.gif')}}" alt="" srcset="">
                                                                @elseif($b_item->status == 3)
                                                                    <img class="w-100" src="{{asset('dist/icons/occupiedbed.png')}}" alt="" srcset="">
                                                                @endif

                                                                @isset ($b_item->ref_no)
                                                                    <small>REF # {{$b_item->ref_no}}</small>
                                                                @endisset

                                                            </a>
                                                        @else

                                                            <a href="/patient/{{$b_item->patient_id}}">
                                                                <p> {{$b_item->bed}} </p>
                                                                @if($b_item->status == 2)
                                                                    <img class="w-100" src="{{asset('dist/icons/incoming.gif')}}" alt="" srcset="">
                                                                @elseif($b_item->status == 3)
                                                                    <img class="w-100" src="{{asset('dist/icons/occupiedbed.png')}}" alt="" srcset="">
                                                                @endif
                                                            </a>
                                                        @endif
                                                    </div>&nbsp;
                                                @endif

                                            @endif

                                        @empty

                                        @endforelse
                                    </div>
                                    <!-- beds container -->

                                </div>
                            @endif
                        @empty
                        @endforelse
                    </div>

                    <!-- no ref bed -->
                    <div class="modal fade" id="modal-no-ref-bed">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title text-muted">NOTE:</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body text-dark">
                                    <h4 class="nb-3">
                                        No refferal found on this bed.
                                    </h4>

                                    <h4 >
                                        This is manually updated by the hospital.
                                    </h4>
                                </div>
                                <div class="modal-footer justify-content-center">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- no ref bed -->


                </div>
                @if ($f)
                    <?php $f=false; ?>
                @endif
            @empty
                <?php $f=true; ?>
                @forelse ($stations as $item)

                    @if (Auth::user()->role != 2)
                        <div class="tab-pane fade @if($f) active show @endif" id="custom-tabs-{{$item->id}}-home" role="tabpanel" aria-labelledby="custom-tabs-{{$item->id}}-home-tab">
                            <div class="row">
                                <div class="col-12">
                                    <a href="/hospital/{{$item->hospital_id}}/station/{{$item->id}}/room/create" class="btn btn-sm rounded-0 btn-secondary text-center">
                                        <i class="fa fa-plus"></i> ROOM
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if ($f)
                        <?php $f=false; ?>
                    @endif
                @empty

                @endforelse
                <h4 class="text-center text-muted">No record found.</h4>
            @endforelse

        </div>
    </div>
    <!-- /.card -->
</div>


@endsection

@section('script')
    <script>
        $(function () {
            $("#tbl-created-referrals").DataTable({
                "responsive": true, "lengthChange": false, "autoWidth": false,
                "buttons": ["colvis"]
            }).buttons().container().appendTo('#tbl-created-referrals_wrapper .col-md-6:eq(0)');

            $("input[data-bootstrap-switch]").each(function(){
                $(this).bootstrapSwitch('state', $(this).prop('checked'));
            });
        });
    </script>
@endsection
