@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>{{$hospital->hospital}}</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="/hospital/{{$hospital->id}}">{{$hospital->hospital}}</a></li>
                <li class="breadcrumb-item active">{{$rooms[0]->station}}</li>
            </ol>
        </div>
    </div>
@endsection

@section('content')

<div class="card">
    <div class="card-header">
        <h3 class="card-title text-capitalize">{{$rooms[0]->station}} - Rooms</h3>

        <!-- super admin only -->
        @if (Auth::user()->role == 3)
            <button class="btn btn-default float-right" data-toggle="modal" data-target="#modal-lg">
                <i class="fa fa-trash"></i>
                Delete this station
            </button>
        @endif
        <!-- super admin only -->

    </div>
    <div class="card-body">
        <div class="row">


            @foreach ($rooms[0]->room as $item)
                <div class="col-12 col-sm-6 col-md-3">

                    @isset($ref_no)
                        <a href="/hospital/{{$item->hospital_id}}/station/{{$item->station_id}}/room/{{$item->id}}/bed?ref_no={{$ref_no}}" class="text-dark">
                    @else
                        @isset($patient_id)
                            <a href="/hospital/{{$item->hospital_id}}/station/{{$item->station_id}}/room/{{$item->id}}/bed?transfer=1&id={{$patient_id}}" class="text-dark">
                        @else
                            <a href="/hospital/{{$item->hospital_id}}/station/{{$item->station_id}}/room/{{$item->id}}/bed" class="text-dark">
                        @endisset

                    @endisset

                        <div class="info-box border-none">
                            <?php $is_avail=false ?>
                            @foreach ($beds[0]->bed as $b)
                                @if ($b->room_id == $item->id && $b->status == 1)
                                    <?php $is_avail=true ?>
                                @endif
                            @endforeach
                            <span class="info-box-icon @if($is_avail) bg-success @else bg-danger @endif elevation-1"><i class="fas fa-folder"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text text-capitalize">{{$item->room}}</span>
                                <span class="font-italic">
                                    <?php $bed_ctr=0 ?>
                                    @foreach ($beds[0]->bed as $b)
                                        @if ($b->room_id == $item->id)
                                            <?php $bed_ctr++ ?>
                                        @endif
                                    @endforeach

                                    <small>Beds = {{$bed_ctr}}</small>
                                </span>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach

            <!-- super admin only -->
            @if (Auth::user()->role == 3)
                <div class="col-12 col-sm-6 col-md-3">
                    <a href="/hospital/{{$rooms[0]->hospital_id}}/station/{{$rooms[0]->id}}/room/create" class="text-dark">
                        <div class="info-box border-none">
                            <span class="info-box-icon bg-secondary elevation-1"><i class="fas fa-plus"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text text-capitalize">New room</span>
                                <span class="info-box-number">

                                </span>
                            </div>
                        </div>
                    </a>
                </div>

                @if (session()->has('room.store'))
                    @if (session()->get('room.store'))
                        <div class="alert alert-success alert-dismissible col-12 mx-2" id="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-check"></i> Success!</h5>
                            New room successfully added
                        </div>
                    @endif
                @endif
            @endif
            <!-- super admin only -->

        </div>
    </div>
    <div class="card-footer">
        <a href="/hospital/{{$hospital->id}}" class="btn btn-danger btn-sm">
            <i class="fa fa-arrow-left"></i> Back
        </a>
    </div>
</div>

<div class="modal fade" id="modal-lg">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fas fa-exclamation-triangle"></i>
                    Delete warning!
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning alert-dismissible mb-0">
                    <h5>
                        This action cannot be undone.<br>
                        Click "Delete" button to delete this station.
                    </h5>
                </div>
            </div>

            <form action="/hospital/station/{{$rooms[0]->id}}" method="post">
                @method('DELETE')
                @csrf
                <div class="modal-footer justify-content-center">
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </div>
            </form>

        </div>
    </div>
</div>

@endsection
