@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Room</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="/hospital/{{$hospital->id}}/station/{{$station->id}}/room">{{$station->station}}</a></li>
            <li class="breadcrumb-item active">Create Station</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/{{$hospital->id}}" class="btn btn-sm btn-success rounded-0" title="Return to {{$hospital->hospital}} dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <form class="form-horizontal" action="/hospital/room" method="POST">
            @csrf
            @isset($room)
                @method('PUT')
                <input type="hidden" name="id" value="{{$room->id}}">
            @endisset
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Hospital *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" value="{{$hospital->hospital}}" readonly>
                        <input type="hidden" class="form-control" id="hospital_id" name="hospital_id" value="{{$hospital->id}}">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Station *</label>
                    <div class="col-sm-10">
                        <input type="hidden" class="form-control" id="station_id" name="station_id" value="{{$station->id}}">
                        <input type="text" class="form-control" value="{{$station->station}}" readonly>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Room *</label>
                    <div class="col-sm-10">
                        @isset($room)
                            <input type="text" class="form-control" id="room" name="room" value="{{$room->room}}">
                        @else
                            <input type="text" class="form-control" id="room" name="room" placeholder="-">
                            @error('room')
                                <span>
                                    {{ $message }}
                                </span>
                            @enderror
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Description</label>
                    <div class="col-sm-10">
                        @isset($room)
                            <input type="text" class="form-control" id="description" name="description" value="{{$room->description}}">
                        @else
                            <input type="text" class="form-control" id="description" name="description" placeholder="-">
                            @error('description')
                                <span>
                                    {{ $message }}
                                </span>
                            @enderror
                        @endisset
                    </div>
                </div>
            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>
                     SAVE
                </button>
            </div>
        </form>

        @if (session()->has('room.store') || session()->has('room.update') || session()->has('room.destroy'))
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                @if (session()->get('room.store'))
                    New room successfully added!
                @elseif(session()->get('room.update'))
                    Update Successful!
                @elseif(session()->get('room.destroy'))
                    Delete Successful!
                @endif
            </div>
        @endif
    </div>
    <hr>
    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Station</th>
                    <th>Room</th>
                    <th>Description</th>
                    <th>Created at</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($rooms as $item)
                    <tr>
                        <td>{{$station->station}}</td>
                        <td>{{$item->room}}</td>
                        <td>{{$item->description}}</td>
                        <td>{{$item->created_at}}</td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/hospital/{{$item->hospital_id}}/station/{{$station->id}}/room/create?id={{$item->id}}" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/hospital/room/{{$item->id}}" method="post">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No beds found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

</div>
@endsection
