@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Hospitals</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Hospitals</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
    <div class="card card-success">
        <div class="card-header">
        </div>
        <div class="card-body">


            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                          <h3 class="card-title">List of Hospitals</h3>

                          @if (Auth::user()->role == 3)
                            <a href="/hospital" class="btn btn-success float-right">
                                <i class="fa fa-plus"></i> NEW HOSPITAL
                            </a>
                          @endif
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body table-responsive">
                          <table id="tbl_hospitals" class="table table-hover text-nowrap">
                            <thead>
                                <tr>
                                    <th>Code</th>
                                    <th>Hospital Name</th>
                                    <th>Address</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($hospitals as $item)
                                    <tr>
                                        <td class="text-capitalize"> {{$item->code}} </td>
                                        <td class="text-capitalize"> {{$item->hospital}} </td>
                                        <td class="text-capitalize"> {{$item->address}} </td>
                                        <td>
                                            <a href="/hospital/{{$item->id}}">
                                                <i class="fa fa-folder"></i>
                                            </a>

                                            @if (Auth::user()->role == 3)
                                                <button class="btn btn-link text-danger" data-toggle="modal" data-target="#modal-hosp{{$item->id}}-delete">
                                                    <i class="fa fa-trash"></i>
                                                </button>

                                                <!-- delete hospital modal -->
                                                <div class="modal fade" id="modal-hosp{{$item->id}}-delete">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title text-dark">Delete Hospital Confirmation</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body text-dark">

                                                                <h4 >
                                                                    <span class="text-muted">HOSPITAL:</span> {{$item->hospital}}
                                                                </h4>
                                                            </div>
                                                            <div class="modal-footer justify-content-center">
                                                                <form action="/hospital/{{$item->id}}" method="post">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-danger">Submit</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- delete hospital modal -->
                                            @endif
                                        </td>
                                    </tr>
                                @empty

                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Code</th>
                                    <th>Hospital Name</th>
                                    <th>Address</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                          </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $(function () {
            //Initialize Select2 Elements
            $('.select2').select2()

            $("#tbl_hospitals").DataTable({
                "responsive": true, "lengthChange": false, "autoWidth": false,
                "buttons": ["excel"]
            }).buttons().container().appendTo('#tbl_hospitals_wrapper .col-md-6:eq(0)');
        });
    </script>
@endsection
