@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Edit Doctor</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Edit Doctor</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Creator: <span class="text-muted font-italic text-capitalize">{{Auth::user()->fname}} {{Auth::user()->lname}}</span></h3>
    </div>
    <div class="card-body">
        <form class="form-horizontal" action="/doctor" method="POST">
            @csrf
            @method('PUT')
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Doctor *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="doctor" value="{{$doctor->doctor}}" autofocus required>
                    </div>
                </div>

                <input type="hidden" name="id" value="{{$doctor->id}}">

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Designation/Station Assigned *</label>
                    <div class="col-sm-10">
                        <select name="designation" class="form-control select2" style="width: 100%;" required>
                            <option value="">-</option>
                            @foreach ($stations as $item)
                                <option value="{{$item->station}}" @if($item->station == $doctor->designation) selected @endif>{{$item->station}}</option>
                            @endforeach
                          </select>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Specialty *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="specialty" value="{{$doctor->specialty}}" required>
                    </div>
                </div>

            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>
                     UPDATE
                </button>
            </div>
        </form>
    </div>

</div>
@endsection

@section('script')
    <script>
        $(function(){
            //Initialize Select2 Elements
            $('.select2').select2()
        })
    </script>
@endsection
