@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Schedule</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Create Bed</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/{{$hospital->id}}" class="btn btn-sm btn-success rounded-0" title="Return to {{$hospital->hospital}} dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <h4 class="text-center text-uppercase">
            {{$hospital->hospital}}
        </h4>
        <h5 class="text-center text-muted">NEW DOCTOR SCHEDULE</h5>
        <hr>

        <form class="form-horizontal" action="/doctor-sched" method="POST">
        @isset($doctor_sched)
            @method('PUT')
        @endisset

            @csrf
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Doctor *</label>
                    <div class="col-sm-10">
                        @isset($doctor_sched)
                            <select class="form-control select2" name="doctor_id" style="width: 100%;" required>
                                <option value="">-</option>
                                @forelse ($doctors as $dr_item)
                                    <option value="{{$dr_item->id}}" @if($doctor_sched->doctor_id == $dr_item->id) selected @endif>{{$dr_item->doctor}}</option>
                                @empty
                                @endforelse
                            </select>
                            <input type="hidden" name="id" value="{{$doctor_sched->id}}">
                            <input type="hidden" name="hospital_id" value="<?= $_GET['hospital_id'] ?>">
                        @else
                            <select class="form-control select2" name="doctor_id" style="width: 100%;" required>
                                <option value="">-</option>
                                @forelse ($doctors as $dr_item)
                                    <option value="{{$dr_item->id}}">{{$dr_item->doctor}}</option>
                                @empty
                                    <option value="">No record found.</option>
                                @endforelse
                            </select>
                            <input type="hidden" name="hospital_id" value="<?= $_GET['hospital_id'] ?>">
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Day *</label>
                    <div class="col-sm-10">
                        @isset($doctor_sched)
                            <input type="date" class="form-control" name="day" value="{{$doctor_sched->day}}">
                        @else
                            <input type="date" class="form-control" name="day">
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">IN *</label>
                    <div class="col-sm-10">
                        @isset($doctor_sched)
                            <input type="time" class="form-control" name="in" value="{{$doctor_sched->in}}">
                        @else
                            <input type="time" class="form-control" name="in">
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">OUT *</label>
                    <div class="col-sm-10">
                        @isset($doctor_sched)
                            <input type="time" class="form-control" name="out" value="{{$doctor_sched->out}}">
                        @else
                            <input type="time" class="form-control" name="out">
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Department *</label>
                    <div class="col-sm-10">
                        @isset($doctor_sched)
                            <select class="form-control select2" name="department" style="width: 100%;" required>
                                <option value="">-</option>
                                <option value="dr" @if($doctor_sched->department == 'dr') selected @endif>Delivery Room</option>
                                <option value="er" @if($doctor_sched->department == 'er') selected @endif>Emergency Room</option>
                                <option value="or" @if($doctor_sched->department == 'or') selected @endif>Operating Room</option>
                                <option value="opd" @if($doctor_sched->department == 'or') selected @endif>Outpatient Department</option>
                            </select>
                        @else
                            <select class="form-control select2" name="department" style="width: 100%;" required>
                                <option value="">-</option>
                                <option value="dr">Delivery Room</option>
                                <option value="er">Emergency Room</option>
                                <option value="or">Operating Room</option>
                                <option value="opd">Outpatient Department</option>
                            </select>
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Remarks</label>
                    <div class="col-sm-10">
                        @isset($doctor_sched)
                            <textarea class="form-control" rows="3" name="remarks">{{$doctor_sched->remarks}}</textarea>
                        @else
                            <textarea class="form-control" rows="3" name="remarks"></textarea>
                        @endisset
                    </div>
                </div>


            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>

                    @isset($doctor_sched)
                        UPDATE
                    @else
                        SAVE
                    @endisset
                </button>
            </div>
        </form>
        @if (session()->has('doc_sched.store') || session()->has('doc_sched.update') || session()->has('doc_sched.destroy'))
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                @if (session()->get('doc_sched.store'))
                    New schedule successfully added!
                @elseif(session()->get('doc_sched.update'))
                    Update Successful!
                @elseif(session()->get('doc_sched.destroy'))
                    Delete Successful!
                @endif
            </div>
        @endif
    </div>
    <hr>
    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Doctor</th>
                    <th>Day</th>
                    <th>IN</th>
                    <th>OUT</th>
                    <th>DESIGNATION</th>
                    <th>Remarks</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($schedules as $sched_item)
                    <tr>
                        <td>{{$sched_item->doctor}}</td>
                        <td>{{$sched_item->day}}</td>
                        <td>{{$sched_item->in}}</td>
                        <td>{{$sched_item->out}}</td>
                        <td>
                            @if ($sched_item->department == 'er')
                                Emergency Room
                            @elseif ($sched_item->department == 'dr')
                                Delivery Room
                            @elseif ($sched_item->department == 'or')
                                Operating Room
                            @elseif ($sched_item->department == 'opd')
                                Outpatient Department
                            @endif
                        </td>
                        <td>{{$sched_item->remarks}}</td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/doctor-sched/edit/{{$sched_item->id}}?hospital_id=<?= $_GET['hospital_id'] ?>" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/doctor-sched" method="post">
                                    @csrf
                                    @method('DELETE')
                                    <input type="hidden" name="sched_id" value="{{$sched_item->id}}">
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center text-muted">No schedule found for this month.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

</div>
@endsection

@section('script')
    <script>
        $(function(){
            //Initialize Select2 Elements
            $('.select2').select2()
        })
    </script>
@endsection
