@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Bed</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Create Bed</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card card-success card-outline card-tabs">
    <div class="card-body">
        <a href="/hospital/{{$hospital->id}}" class="btn btn-sm btn-success rounded-0" title="Return to {{$hospital->hospital}} dashboard">
            <i class="fa fa-chevron-left"></i> Return
        </a>
        <h4 class="text-center text-uppercase">
            {{$hospital->hospital}}
        </h4>
        <h5 class="text-center text-muted">DEPARTMENT BEDS</h5>
        <hr>

        <form class="form-horizontal" action="/department" method="POST">
        @isset($department)
            @method('PUT')
        @endisset

            @csrf
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Bed *</label>
                    <div class="col-sm-10">
                        @isset($department)
                            <input type="text" class="form-control" name="bed" value="{{$department->bed}}" autofocus required>
                            <input type="hidden" name="id" value="{{$department->id}}">
                        @else
                            <input type="text" class="form-control" name="bed" value="" autofocus required>
                            <input type="hidden" name="hospital_id" value="<?= $_GET['hospital_id'] ?>">
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Description</label>
                    <div class="col-sm-10">
                        @isset($department)
                            <input type="text" class="form-control" name="description" value="{{$department->description}}">
                        @else
                            <input type="text" class="form-control" name="description">
                        @endisset
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Department *</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" name="type" style="width: 100%;" required>
                            <option value="">-</option>

                            @isset($department)
                                <option value="dr" @if($department->type == 'dr') selected @endif>Delivery Room</option>
                                <option value="er" @if($department->type == 'er') selected @endif>Emergency Room</option>
                                <option value="or" @if($department->type == 'or') selected @endif>Operation Room</option>
                                <option value="opd" @if($department->type == 'opd') selected @endif>Outpatient Department</option>
                            @else
                                <option value="dr">Delivery Room</option>
                                <option value="er">Emergency Room</option>
                                <option value="or">Operating Room</option>
                                <option value="opd">Outpatient Department</option>
                            @endisset
                        </select>
                    </div>
                </div>
            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>

                    @isset($doctor)
                        UPDATE
                    @else
                        SAVE
                    @endisset
                </button>
            </div>
        </form>
        @if (session()->has('department.store') || session()->has('department.update') || session()->has('department.destroy'))
            <div class="alert alert-success alert-dismissible col-12 mt-3" id="alert">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <i class="icon fas fa-check"></i>
                @if (session()->get('department.store'))
                    New bed successfully added!
                @elseif(session()->get('department.update'))
                    Update Successful!
                @elseif(session()->get('department.destroy'))
                    Delete Successful!
                @endif
            </div>
        @endif
    </div>
    <hr>
    <div class="card-body table-responsive p-4">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Bed</th>
                    <th>Department</th>
                    <th>Description</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($department_beds as $db_item)
                    <tr>
                        <td>{{$db_item->bed}}</td>
                        <td>
                            @if ($db_item->type == 'er')
                                Emergency Room
                            @elseif ($db_item->type == 'dr')
                                Delivery Room
                            @elseif ($db_item->type == 'or')
                                Operating Room
                            @elseif ($db_item->type == 'opd')
                                Outpatient Department
                            @endif
                        </td>
                        <td>{{$db_item->description}}</td>
                        <td>
                            <div class="float-right d-flex">
                                <a href="/department/edit/{{$db_item->id}}" class="btn btn-sm btn-info">
                                    <i class="fa fa-edit"></i>
                                </a>
                                &nbsp;
                                <form action="/department" method="post">
                                    @csrf
                                    @method('DELETE')
                                    <input type="hidden" name="db_id" value="{{$db_item->id}}">
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No beds found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

</div>
@endsection

@section('script')
    <script>
        $(function(){
            //Initialize Select2 Elements
            $('.select2').select2()
        })
    </script>
@endsection
