@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Create Hospital</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Create hospital</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Creator: <span class="text-muted font-italic text-capitalize">{{Auth::user()->fname}} {{Auth::user()->lname}}</span></h3>
    </div>
    <div class="card-body">
        <form class="form-horizontal" action="/hospital" method="POST">
            @csrf
            <div class="card-body">
                <div class="form-group row">
                    <label for="inputEmail3" class="col-sm-2 col-form-label">Hospital *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="hospital" name="hospital" placeholder="-" required>
                        @error('hospital')
                            <span>
                                {{ $message }}
                            </span>
                        @enderror
                    </div>
                </div>
                <div class="form-group row">
                    <label for="inputPassword3" class="col-sm-2 col-form-label">Address *</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="address" name="address" placeholder="-" required>
                        @error('address')
                            <span>
                                {{ $message }}
                            </span>
                        @enderror
                    </div>
                </div>

                @if (session()->has('hospital.store'))
                    @if (session()->get('hospital.store'))
                        <div class="row">
                            <div class="alert alert-success alert-dismissible col-12" id="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <h5><i class="icon fas fa-check"></i> Success!</h5>
                                New hospital successfully added
                            </div>
                        </div>
                    @endif
                @endif
            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-save mr-1"></i>
                     SAVE
                </button>
            </div>
        </form>
    </div>

</div>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Hospitals as of [<span class="text-muted font-italic">{{date('Y-m-d')}}</span>]</h3>

        <div class="card-tools">

        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Hospital</th>
                    <th>Address</th>
                    <th>Capacity</th>
                    <th>Date Created</th>
                    <th style="width: 5%"></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($hospitals as $item)
                    <tr>
                        <td> {{$item->hospital}} </td>
                        <td> {{$item->address}} </td>
                        <td>-</td>
                        <td> {{$item->created_at}} </td>
                        <td>
                            <a href="/hospital/{{$item->id}}">
                                <i class="fa fa-folder"></i>
                            </a>
                        </td>
                    </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center text-muted">Sorry, no data available.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.card -->
@endsection
