@extends('layouts.app')

@section('bread-crumb')
    <div class="row mb-2">
        <div class="col-sm-6">
        <h1>Dispatch Ambulance</h1>
        </div>
        <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item active">Dispatch Ambulance</li>
        </ol>
        </div>
    </div>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Dispatcher: <span class="text-muted font-italic text-capitalize">{{Auth::user()->fname}} {{Auth::user()->lname}}</span></h3>
    </div>
    <div class="card-body">
        <form class="form-horizontal" action="/ambulance/dispatch" method="POST">
            @csrf
            @method('PUT')
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Ambulance</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" name="id" style="width: 100%;" name="" id="" required>
                            <option value="">-</option>
                            @forelse ($ambulances as $ambu_item)
                                <option value="{{$ambu_item->id}}">{{$ambu_item->ambulance}}</option>
                            @empty
                                <option value="">No available ambulance</option>
                            @endforelse
                        </select>
                    </div>
                </div>

                <input type="hidden" name="hospital_id" value="<?= $_GET['hospital_id'] ?>">

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">Referral #</label>
                    <div class="col-sm-10">
                        <select class="form-control select2" name="ref_id" style="width: 100%;" name="" id="" required>
                            <option value="">-</option>
                            @forelse ($referrals as $r_item)
                                <option value="{{$r_item->id}}">REF # {{$r_item->referral_no}} [ {{$r_item->patient}} ]</option>
                            @empty
                                <option value="">No record found.</option>
                            @endforelse
                        </select>
                    </div>
                </div

            </div>
            <div class="card-footer justify-content-center row">
                <button type="submit" class="btn btn-info">
                    <i class="fa fa-ambulance mr-1"></i>
                     DISPATCH
                </button>
            </div>
        </form>
    </div>

</div>
@endsection
@section('script')
    <script>
        $(function () {
            //Initialize Select2 Elements
            $('.select2').select2()
        });
    </script>
@endsection
