@extends('layouts.app')

@section('content')
<div class="card card-danger">
    <div class="card-header">
        <h3 class="card-title">
            BIG HOSPITALS
        </h3>
    </div>
    <div class="card-body">

        <div class="row">
            <?php $big_four = ['cdh', 'tljph', 'vdh', 'ldzdh']; ?>
            @foreach ($regular_beds as $item)
                @if (in_array( strtolower($item->code), $big_four ))
                    <div class="col-md-3 col-12 mb-2">
                        <div class="card">
                            <div class="card-header">
                                <a href="/hospital/{{$item->id}}">
                                    <p class="text-center bg-olive p-2">{{$item->hospital}}</p>
                                </a>
                            </div>

                            <div class="card-body">
                                <canvas id="{{$item->code}}" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                            </div>

                            <div class="card-footer text-center">
                                <p class="text-muted">CAPACITY: {{$item->total_beds}}</p>
                            </div>
                        </div>
                    </div>
                @endif

            @endforeach
        </div>

    </div>
</div>

<div class="card card-success">
    <div class="card-header">
        <h3 class="card-title">
            SMALL HOSPITALS
        </h3>
    </div>
    <div class="card-body">

        <div class="row">
            <?php $big_four = ['cdh', 'tljph', 'vdh', 'ldzdh']; ?>
            @foreach ($regular_beds as $item)
                @if (!in_array( strtolower($item->code), $big_four ))
                    <div class="col-md-3 col-12 mb-2">
                        <div class="card">
                            <div class="card-header">
                                <a href="/hospital/{{$item->id}}">
                                    <p class="text-center bg-olive p-2">{{$item->hospital}}</p>
                                </a>
                            </div>

                            <div class="card-body">
                                <canvas id="{{$item->code}}" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                            </div>

                            <div class="card-footer text-center">
                                <p class="text-muted">CAPACITY: {{$item->total_beds}}</p>
                            </div>
                        </div>
                    </div>
                @endif

            @endforeach
        </div>

    </div>
</div>
@endsection

@section('script')
    <script>
        $(function(){

            //view big four hospitals
            @foreach ($regular_beds as $h_item)

                @if (in_array( strtolower($h_item->code), $big_four ))

                    var occupied=0, available=0
                    @foreach ($occupied as $o_item)
                        @if($o_item->hospital == $h_item->hospital)
                            occupied = {{$o_item->occupied}}
                        @endif
                    @endforeach

                    @foreach ($available as $o_item)
                        @if($o_item->hospital == $h_item->hospital)
                            available = {{$o_item->available}}
                        @endif
                    @endforeach


                    var donutData        = {
                            labels: [
                                'Occupied',
                                'Available'
                            ],
                            datasets: [
                                {
                                data: [occupied,available],
                                backgroundColor : ['#800000', '#00cc00'],
                                }
                            ]
                        }
                    var id = "{{$h_item->code}}"
                    var pieChartCanvas = $('#'+id).get(0).getContext('2d')
                    var pieData        = donutData;
                    var pieOptions     = {
                    maintainAspectRatio : false,
                    responsive : true,
                    }
                    //Create pie or douhnut chart
                    // You can switch between pie and douhnut using the method below.
                    var pieChart = new Chart(pieChartCanvas, {
                    type: 'pie',
                    data: pieData,
                    options: pieOptions
                    })

                @endif

            @endforeach

            // view small hospitals
            @foreach ($regular_beds as $h_item)

                @if (!in_array( strtolower($h_item->code), $big_four ))

                    var occupied=0, available=0
                    @foreach ($occupied as $o_item)
                        @if($o_item->hospital == $h_item->hospital)
                            occupied = {{$o_item->occupied}}
                        @endif
                    @endforeach

                    @foreach ($available as $o_item)
                        @if($o_item->hospital == $h_item->hospital)
                            available = {{$o_item->available}}
                        @endif
                    @endforeach


                    var donutData        = {
                            labels: [
                                'Occupied',
                                'Available'
                            ],
                            datasets: [
                                {
                                data: [occupied,available],
                                backgroundColor : ['#800000', '#00cc00'],
                                }
                            ]
                        }
                    var id = "{{$h_item->code}}"
                    var pieChartCanvas = $('#'+id).get(0).getContext('2d')
                    var pieData        = donutData;
                    var pieOptions     = {
                    maintainAspectRatio : false,
                    responsive : true,
                    }
                    //Create pie or douhnut chart
                    // You can switch between pie and douhnut using the method below.
                    var pieChart = new Chart(pieChartCanvas, {
                    type: 'pie',
                    data: pieData,
                    options: pieOptions
                    })

                @endif

            @endforeach


        })
    </script>
@endsection
