<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnToReferralsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('referrals', function (Blueprint $table) {
            $table->string('o2_sat')->nullable();
            $table->boolean('rtpcr')->nullable();
            $table->text('add_instruction')->nullable();
            $table->boolean('vaccine_1st_dose')->default(false);
            $table->boolean('vaccine_2nd_dose')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('referrals', function (Blueprint $table) {
            $table->dropColumn('o2_sat');
            $table->dropColumn('rtpcr');
            $table->dropColumn('add_instruction');
            $table->dropColumn('vaccine_1st_dose');
            $table->dropColumn('vaccine_2nd_dose');
        });
    }
}
