<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReferralLocationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('referral_locations', function (Blueprint $table) {
            $table->id();
            $table->integer('ref_id');
            $table->boolean('origin')->default(true);
            $table->boolean('ambulance')->default(false);
            $table->boolean('dept_bed')->default(false);
            $table->boolean('bed')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('referral_locations');
    }
}
