<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsInPatients extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('patients', function (Blueprint $table) {
            $table->integer('hospital_id');
            $table->integer('station_id');
            $table->integer('room_id');
            $table->integer('bed_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('patients', function (Blueprint $table) {
            $table->dropColumn('hospital_id');
            $table->dropColumn('station_id');
            $table->dropColumn('room_id');
            $table->dropColumn('bed_id');
        });
    }
}
