<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    protected $fillable = ['hospital_id', 'station_id', 'room', 'description'];

    public function bed()
    {
        return $this->hasMany(Bed::class, 'room_id', 'id');
    }

    //inverse
    public function station()
    {
        return $this->belongsTo(Station::class, 'station_id', 'id');
    }

    public function hospital()
    {
        return $this->belongsTo(Hospital::class, 'hospital_id', 'id');
    }
}
