<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Referral;
use App\Hospital;
use App\Drrmo;
use App\Patient;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ReportController extends Controller
{
    public function __construc()
    {
        $this->middleware('auth');
    }

    public function admin()
    {
        $auth = Auth::user();
        if ($auth->role == 1 || $auth->role == 4) return redirect()->back();

        $data = [
            'patient'       =>  Referral::where('is_internal', true)->count(),
            'referral'      =>  Referral::where('is_internal', false)->count(),
            'hospital'      =>  Referral::where('ref_from_hospital', '!=', null)->count(),
            'lgu'           =>  Referral::where('ref_from_drrmo', '!=', null)->count('id'),
            'on_process'    =>  Referral::where('is_internal', false)->where('ref_status', 1)->count(),
            'referred'      =>  Referral::where('is_internal', false)->where('ref_status', 2)->count(),
            'admitted'      =>  Referral::where('is_internal', false)->where('ref_status', 3)->count(),
            'released'      =>  Referral::where('is_internal', false)->where('ref_status', 4)->count(),
            'lgus'          =>  Drrmo::select('id')->get()
        ];
        $hospitals = array();
        $hosp_arr = DB::table('hospitals')->select('code', 'id')->get();
        foreach ($hosp_arr as $h) {
            $hospitals[$h->code] = Referral::where('ref_from_hospital', $h->id)->count();
        }
        $data['hospitals'] = $hospitals;

        $lgus = array();

        $lgu_arr = DB::table('drrmos')->select('drrmo', 'id')->get();
        foreach ($lgu_arr as $l) {
            $lgus[$l->drrmo] = Referral::where('ref_from_drrmo', $l->id)->count();
        }
        $data['lgus'] = $lgus;

        return view('report.admin', $data);
    }

    public function hospital()
    {
        if (Auth::user()->role != 1) return redirect()->back();
        $hosp_id = Auth::user()->hospital_id;
        $data = [
            'received'              =>  Referral::where('ref_to_hospital', $hosp_id)->count(),
            'received_today'        =>  Referral::where('ref_to_hospital', $hosp_id)->whereDate('ref_to_date', Carbon::today())->count(),
            'incoming'              =>  Referral::where('ref_to_hospital', $hosp_id)->where('ref_status', 2)->count(),
            'admitted'              =>  Referral::where('ref_to_hospital', $hosp_id)->where('ref_status', 3)->count(),
            'released'              =>  Referral::where('ref_to_hospital', $hosp_id)->where('ref_status', 4)->count(),
            'created'               =>  Referral::where('ref_from_hospital', $hosp_id)->count(),
            'created_on_process'    =>  Referral::where('ref_from_hospital', $hosp_id)->where('ref_status', 1)->count(),
            'created_referred'      =>  Referral::where('ref_from_hospital', $hosp_id)->where('ref_status', 2)->count(),
            'created_admitted'      =>  Referral::where('ref_from_hospital', $hosp_id)->where('ref_status', 3)->count(),
            'created_released'      =>  Referral::where('ref_from_hospital', $hosp_id)->where('ref_status', 4)->count(),
            'created_today'         =>  Referral::where('ref_from_hospital', $hosp_id)->whereDate('created_at', Carbon::today())->count(),
            'patient_encoded'       =>  Referral::where('is_internal', true)->where('ref_to_hospital', $hosp_id)->count(),
            'patient_encoded_admitted'       =>  Referral::where('is_internal', true)->where('ref_to_hospital', $hosp_id)->where('ref_status', 3)->count(),
            'patient_encoded_released'       =>  Referral::where('is_internal', true)->where('ref_to_hospital', $hosp_id)->where('ref_status', 4)->count()
        ];

        return view('report.hospital', $data);
    }

    public function lgu()
    {
        if (Auth::user()->role != 4) return redirect()->back();
        $drrmo_id = Auth::user()->drrmo_id;

        $data = [
            'created'               =>  Referral::where('ref_from_drrmo', $drrmo_id)->count(),
            'created_on_process'    =>  Referral::where('ref_from_drrmo', $drrmo_id)->where('ref_status', 1)->count(),
            'created_referred'      =>  Referral::where('ref_from_drrmo', $drrmo_id)->where('ref_status', 2)->count(),
            'created_admitted'      =>  Referral::where('ref_from_drrmo', $drrmo_id)->where('ref_status', 3)->count(),
            'created_released'      =>  Referral::where('ref_from_drrmo', $drrmo_id)->where('ref_status', 4)->count(),
            'created_today'         =>  Referral::where('ref_from_drrmo', $drrmo_id)->whereDate('created_at', Carbon::today())->count()
        ];

        return view('report.lgu', $data);
    }
}
