<?php

namespace App\Http\Controllers;

use App\Referral;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class Referral2Controller extends Controller
{
    public $where = [];
    public $result;
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function search(Request $request)
    {
        $role = Auth::user()->role;
        switch ($role) {
            case 1:
                array_push($this->where, ['ref_to_hospital', Auth::user()->hospital_id]);
                if ($request->search_by === 'name') $this->result = $this->searchByName($request->search);
                if ($request->search_by === 'ref_no') $this->result = $this->searchByRefNo($request->search);
                break;

            case 2:
                array_push($this->where, ['is_internal', false]);
                if ($request->search_by === 'name') $this->result = $this->searchByName($request->search);
                if ($request->search_by === 'ref_no') $this->result = $this->searchByRefNo($request->search);
                break;

            case 3:
                array_push($this->where, ['is_internal', false]);
                if ($request->search_by === 'name') $this->result = $this->searchByName($request->search);
                if ($request->search_by === 'ref_no') $this->result = $this->searchByRefNo($request->search);
                break;

            case 4:
                array_push($this->where, ['ref_from_drrmo', Auth::user()->drrmo_id]);
                if ($request->search_by === 'name') $this->result = $this->searchByName($request->search);
                if ($request->search_by === 'ref_no') $this->result = $this->searchByRefNo($request->search);
                break;
        }

        return response()->json($this->result);
    }

    public function filter(Request $request)
    {
        $auth = Auth::user();

        switch ($auth->role) {
            case 1:
                $request->route == 'created' ? array_push($this->where, ['ref_from_hospital', $auth->hospital_id]) : null;
                $request->route == 'received' ? array_push($this->where, ['ref_to_hospital', $auth->hospital_id]) : null;
                break;

            case 2:
                array_push($this->where, ['is_internal', false]);
                break;

            case 3:
                array_push($this->where, ['is_internal', false]);
                break;

            case 4:
                array_push($this->where, ['ref_from_drrmo', $auth->drrmo_id]);
                break;
        }

        $request->status == 'on_process' ? array_push($this->where, ['ref_status', 1]) : null;
        $request->status == 'incoming' ? array_push($this->where, ['ref_status', 2]) : null;
        $request->status == 'referred' ? array_push($this->where, ['ref_status', 2]) : null;
        $request->status == 'admitted' ? array_push($this->where, ['ref_status', 3]) : null;
        $request->status == 'released' ? array_push($this->where, ['ref_status', 4]) : null;

        if ($request->date_from != '') {
            $referrals = Referral::whereBetween('created_at', [$request->date_from, $request->date_to])->where($this->where)->orderBy('id', 'desc')->get();
        } else {
            $referrals = Referral::where($this->where)->orderBy('id', 'desc')->get();
        }

        return response()->json($referrals);
    }

    public function searchByName($name)
    {
        array_push($this->where, ['patient', 'like', '%' . $name . '%']);
        return Referral::where($this->where)->limit(5)->get();
    }

    public function searchByRefNo($ref_no)
    {
        array_push($this->where, ['referral_no', 'like', '%' . $ref_no . '%']);
        return Referral::where($this->where)->limit(5)->get();
    }
}
