<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Hospital;
use App\Drrmo;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class ProfileController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function profile()
    {
        $user = Auth::user();
        $data = [
            'user' => $user,
            'hospital' => Hospital::find($user->hospital_id),
            'lgu' => Drrmo::find($user->drrmo_id)
        ];
        return view('user.profile', $data);
    }

    public function change_pass()
    {
        $user = Auth::user();
        return view('user.change-pass');
    }

    public function save_pass(Request $request)
    {
        $user = Auth::user();
        $update = User::find($user->id);

        $check = Hash::check($request->old_password, $update->password);
        if(!$check) {
            return redirect()->back()->with('err_old_pass', 'Old password is not correct.');
        }

        $this->validate($request,  [
            'password' => 'required|string|min:8|confirmed'
        ]);


        $update->password = Hash::make($request->password);
        $update->save();

        return redirect()->back()->with('success', 'Password updated successfully.');

    }
}
