<?php

namespace App\Http\Controllers;

use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\EmailController;
use Illuminate\Support\Facades\Hash;

class PasswordResetLogController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $all_users = User::get();
        return view('users.pass-reset', ['all_users'=>$all_users]);
    }

    public function update(Request $request)
    {
        // dd($request->user_id);
        $ctr = count($request->user_id);
        $user_ids = $request->user_id;

        for ($i=0; $i < $ctr ; $i++) {

            $uid = $user_ids[$i];
            $user = User::where('id', $uid)->first();
            $name = $user->fname .' '. $user->lname;
            $email = $user->email;
            $newpass = $this->rand_string(12);
            $user->password = Hash::make($newpass);
            $user->last_reset_date = now();
            $user->save();

            EmailController::passwordResetEmail(
                $name,
                $newpass,
                $email
            );

        }

        return redirect()->back()->with('reset', true);
    }

    function rand_string( $length ) {
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        return substr(str_shuffle($chars),0,$length);
    }
}
