<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Hospital;
use App\Notification;
use Illuminate\Support\Facades\Auth;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $role = Auth::user()->role;
        if($role == 1) {
            $notifs = Notification::where([ ['receiver_key', Auth::user()->hospital_id], ['is_seen', false] ])->get();
        } elseif($role == 2) {
            $notifs = Notification::where([ ['receiver_role', 2], ['is_seen', false] ])->get();
        } elseif($role == 4) {
            $notifs = Notification::where([ ['receiver_key', Auth::user()->drrmo_id], ['is_seen', false] ])->get();
        } else {
            return view('home');
        }
        return view('home', ['notifs'=>$notifs]);
    }
}
