<?php

namespace App\Http\Controllers;

use App\DoctorSchedule;
use App\Doctor;
use App\Hospital;
use Illuminate\Http\Request;

use Carbon\Carbon;

class DoctorScheduleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $hospital_id = $request->hospital_id;

        $data = [
            'doctors'       => Doctor::where('hospital_id', $hospital_id)->get(),
            'hospital'      => Hospital::where('id', $hospital_id)->first(),
            'schedules'     => DoctorSchedule::select('doctor_schedules.*', 'doctors.doctor')
                                ->join('doctors', 'doctors.id', '=', 'doctor_schedules.doctor_id')
                                ->where('doctors.hospital_id', $hospital_id)
                                ->whereYear('day', Carbon::now()->year)
                                ->whereMonth('day', Carbon::now()->month)->get()
        ];

        return view('hospitals.doc_sched.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $sched = new DoctorSchedule();
        $sched->doctor_id   = $request->doctor_id;
        $sched->day         = $request->day;
        $sched->in          = $request->in;
        $sched->out         = $request->out;
        $sched->department  = $request->department;
        $sched->remarks     = $request->remarks;
        $sched->save();

        return redirect()->back()->with('doc_sched.store', true);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\DoctorSchedule  $doctorSchedule
     * @return \Illuminate\Http\Response
     */
    public function show(DoctorSchedule $doctorSchedule)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\DoctorSchedule  $doctorSchedule
     * @return \Illuminate\Http\Response
     */
    public function edit(DoctorSchedule $doctorSchedule, Request $request)
    {
        $hospital_id = $request->hospital_id;
        $data = [
            'doctors'       => Doctor::where('hospital_id', $hospital_id)->get(),
            'hospital'      => Hospital::where('id', $hospital_id)->first(),
            'schedules'     => DoctorSchedule::select('doctor_schedules.*', 'doctors.doctor')
                                ->join('doctors', 'doctors.id', '=', 'doctor_schedules.doctor_id')
                                ->where('doctors.hospital_id', $hospital_id)
                                ->whereYear('day', Carbon::now()->year)
                                ->whereMonth('day', Carbon::now()->month)->get(),
            'doctor_sched'  => $doctorSchedule
        ];

        return view('hospitals.doc_sched.create', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\DoctorSchedule  $doctorSchedule
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DoctorSchedule $doctorSchedule)
    {
        $sched = DoctorSchedule::where('id', $request->id)->first();
        $sched->doctor_id   = $request->doctor_id;
        $sched->day         = $request->day;
        $sched->in          = $request->in;
        $sched->out         = $request->out;
        $sched->department  = $request->department;
        $sched->remarks     = $request->remarks;
        $sched->save();
        return redirect('/doctor-sched/create?hospital_id='.$request->hospital_id)->with('doc_sched.update', true);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\DoctorSchedule  $doctorSchedule
     * @return \Illuminate\Http\Response
     */
    public function destroy(DoctorSchedule $doctorSchedule, Request $request)
    {
        DoctorSchedule::where('id', $request->sched_id)->delete();
        return redirect()->back()->with('doc_sched.destroy', true);
    }
}
