<?php

namespace App\Http\Controllers;

use App\Doctor;
use App\Station;
use App\Hospital;
use Illuminate\Http\Request;

class DoctorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $data = [
            'doctors' => Doctor::where('hospital_id', $request->hospital_id)->get(),
            'hospital'=> Hospital::where('id', $request->hospital_id)->first(),
        ];
        return view('hospitals.doctor.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $doctor = new Doctor();
        $doctor->doctor = $request->doctor;
        $doctor->specialty = $request->specialty;
        $doctor->hospital_id = $request->hospital_id;
        $doctor->save();

        // return redirect('/hospital/'.$request->hospital_id);
        return redirect()->back()->with('doctor.store', true);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Doctor  $doctor
     * @return \Illuminate\Http\Response
     */
    public function show(Doctor $doctor)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Doctor  $doctor
     * @return \Illuminate\Http\Response
     */
    public function edit(Doctor $doctor)
    {
        $data = [
            'doctor'    => $doctor,
            'doctors' => Doctor::where('hospital_id', $doctor->hospital_id)->get(),
            'hospital'=> Hospital::where('id', $doctor->hospital_id)->first(),
        ];

        return view('hospitals.doctor.create', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Doctor  $doctor
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Doctor $doctor)
    {
        $doctor = Doctor::where('id', $request->id)->first();

        $doctor->doctor = $request->doctor;
        $doctor->specialty = $request->specialty;
        $doctor->save();
        return redirect('/doctor/create?hospital_id='.$doctor->hospital_id)->with('doctor.update', true);
    }

    public function update_list(Request $request)
    {
        Doctor::where('hospital_id', $request->hospital_id)->update([
            'status'  =>  false,
            'latest_update' => now()
        ]);

        if($request->status != null)
        {
            $ids = $request->status;
            for ($i=0; $i < count($ids)  ; $i++) {
                Doctor::where('id', $ids[$i])->update([
                    'status'        =>  true
                ]);
            }
        }
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Doctor  $doctor
     * @return \Illuminate\Http\Response
     */
    public function destroy(Doctor $doctor, Request $request)
    {
        Doctor::where('id', $request->dr_id)->delete();
        return redirect()->back()->with('doctor.destroy', true);
    }
}
