<?php

namespace App\Http\Controllers;

use App\DepartmentBed;
use App\Hospital;
use Illuminate\Http\Request;

class DepartmentBedController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $hospital_id = $request->hospital_id;

        $data = [
            'hospital'          => Hospital::where('id', $hospital_id)->first(),
            'department_beds'   => DepartmentBed::where('hospital_id', $hospital_id)->orderBy('type', 'desc')->get()
        ];

        return view('hospitals.department.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $department_bed                 = new DepartmentBed();
        $department_bed->bed            = $request->bed;
        $department_bed->hospital_id    = $request->hospital_id;
        $department_bed->description    = $request->description;
        $department_bed->type           = $request->type;
        $department_bed->save();

        return redirect()->back()->with('department.store', true);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Departments  $departments
     * @return \Illuminate\Http\Response
     */
    public function show(Departments $departments)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Departments  $departments
     * @return \Illuminate\Http\Response
     */
    public function edit(DepartmentBed $department)
    {
        $data = [
            'hospital'          => Hospital::where('id', $department->hospital_id)->first(),
            'department_beds'   => DepartmentBed::where('hospital_id', $department->hospital_id)->orderBy('type', 'desc')->get(),
            'department'        => $department
        ];
        return view('hospitals.department.create', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Departments  $departments
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DepartmentBed $department)
    {
        $department_bed = DepartmentBed::where('id', $request->id)->first();
        $department_bed->bed            = $request->bed;
        $department_bed->description    = $request->description;
        $department_bed->type           = $request->type;
        $department_bed->save();
        return redirect('/department/create?hospital_id='.$department_bed->hospital_id)->with('department.update', true);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Departments  $departments
     * @return \Illuminate\Http\Response
     */
    public function destroy(DepartmentBed $department, Request $request)
    {
        DepartmentBed::where('id', $request->db_id)->delete();
        return redirect()->back()->with('department.destroy', true);
    }

    public function dept_occupied(DepartmentBed $department)
    {
        $department->status = 3;
        $department->save();
        return redirect()->back();
    }

    public function dept_available(DepartmentBed $department)
    {
        $department->status = 1;
        $department->save();
        return redirect()->back();
    }
}
