<?php

namespace App\Http\Controllers;
use App\Referral;
use App\Comment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
class CommentController extends Controller
{
    public function __contruct()
    {
        return $this->middleware('auth');
    }

    public function store(Request $request, Referral $referral)
    {
        $auth = Auth::user();
        $comment = Comment::create(array_merge(request()->all(), ['referral_id'=>$referral->id, 'commentor_id'=>$auth->id, 'commentor'=>$auth->fname.' '.$auth->lname]));
        if($referral->ref_status == 1) {

            if($auth->role == 2) {
                if($referral->ref_from_hospital) {
                    NotificationController::store(
                        'comment',
                        ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                        '/referral/'.$referral->id,
                        '1',
                        $referral->ref_from_hospital,
                        $referral->referral_no,
                        'cmt'.$comment->id
                    );
                } else {
                    NotificationController::store(
                        'comment',
                        ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                        '/referral/'.$referral->id,
                        '4',
                        $referral->ref_from_drrmo,
                        $referral->referral_no,
                        'cmt'.$comment->id
                    );
                }
            } else {
                NotificationController::store(
                    'comment',
                    ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                    '/referral/'.$referral->id,
                    '2',
                    '0',
                    $referral->referral_no,
                    'cmt'.$comment->id
                );
            }

        } else {

            if($auth->role == 2) {

                if ($referral->ref_from_hospital) {
                    NotificationController::store(
                        'comment',
                        ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                        '/referral/'.$referral->id,
                        '1',
                        $referral->ref_from_hospital,
                        $referral->referral_no,
                        'cmt'.$comment->id
                    );
                }

                if ($referral->ref_to_hospital) {
                    NotificationController::store(
                        'comment',
                        ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                        '/referral/'.$referral->id,
                        '1',
                        $referral->ref_to_hospital,
                        $referral->referral_no,
                        'cmt'.$comment->id
                    );
                }

                if ($referral->ref_from_drrmo) {
                    NotificationController::store(
                        'comment',
                        ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                        '/referral/'.$referral->id,
                        '4',
                        $referral->ref_from_drrmo,
                        $referral->referral_no,
                        'cmt'.$comment->id
                    );
                }
                
            } else {
                NotificationController::store(
                    'comment',
                    ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                    '/referral/'.$referral->id,
                    '2',
                    '0',
                    $referral->referral_no,
                    'cmt'.$comment->id
                );

                if($auth->hospital_id == $referral->ref_from_hospital || $auth->drrmo_id == $referral->ref_from_drrmo) {
                    NotificationController::store(
                        'comment',
                        ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                        '/referral/'.$referral->id,
                        '1',
                        $referral->ref_to_hospital,
                        $referral->referral_no,
                        'cmt'.$comment->id
                    );
                } elseif ($auth->hospital_id == $referral->ref_to_hospital) {
                    if ($referral->ref_from_hospital) {
                        NotificationController::store(
                            'comment',
                            ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                            '/referral/'.$referral->id,
                            '1',
                            $referral->ref_from_hospital,
                            $referral->referral_no,
                            'cmt'.$comment->id
                        );
                    }
    
                    if ($referral->ref_from_drrmo) {
                        NotificationController::store(
                            'comment',
                            ucwords($auth->fname.' '.$auth->lname). ' commented on referral ['.$referral->referral_no.']',
                            '/referral/'.$referral->id,
                            '4',
                            $referral->ref_from_drrmo,
                            $referral->referral_no,
                            'cmt'.$comment->id
                        );
                    }
                } 
            }

        }
        
        return redirect('/referral/'.$referral->id.'#cmt'.$comment->id);
    }
}
