<?php

namespace App\Http\Controllers;
use App\User;
use App\AssignedUser;
use App\Hospital;
use App\Drrmo;
use App\Http\Controllers\AuditTrailController;
use Illuminate\Http\Request;

class AssignedUserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'role' => 'required',
        ]);

        AssignedUser::create(request()->all());


        User::where('id', $request->user_id)->update(['active'=>1, 'assigned'=>true, 'hospital_id'=>$request->hospital_id, 'drrmo_id'=>$request->drrmo_id, 'role'=>$request->role]);
        $user = User::where('id', $request->user_id)->first();
        $fullname = $user->fname.' '.$user->lname;

        $role = '';
        if($request->role == 1) {
            $role = 'Hospital user';
        } elseif($request->role == 2) {
            $role = 'HOD Head';
        } elseif($request->role == 3) {
            $role = 'Super Admin';
        } elseif($request->role == 4) {
            $role = 'DRRMO';
        }

        if(isset($request->hospital_id)) {
            $hospital = Hospital::where('id', $request->hospital_id)->first();
            $remarks = 'Assigned user, '.ucwords($fullname). ' to '. ucwords($hospital->hospital) . ' as '.$role;
        } elseif(isset($request->hospital_id)) {
            $drrmo = Drrmo::where('id', $request->drrmo_id)->first();
            $remarks = 'Assigned user, '.ucwords($fullname). ' to '. ucwords($drrmo->drrmo) . ' as '.$role;
        } else {
            $remarks = 'Assigned user, '.ucwords($fullname). ' as '.$role;
        }

        AuditTrailController::store(
            'assigned_user',
            'assign user',
            $remarks
        );

        return redirect()->back()->with('assigned_user.store', true);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\AssignedUser  $assignedUser
     * @return \Illuminate\Http\Response
     */
    public function show(AssignedUser $assignedUser)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\AssignedUser  $assignedUser
     * @return \Illuminate\Http\Response
     */
    public function edit(AssignedUser $assignedUser)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\AssignedUser  $assignedUser
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AssignedUser $assignedUser)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\AssignedUser  $assignedUser
     * @return \Illuminate\Http\Response
     */
    public function destroy(AssignedUser $assignedUser)
    {
        //
    }
}
