<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Hospital extends Model
{
    public function station()
    {
        return $this->hasMany(Station::class, 'hospital_id', 'id');
    }

    public function room()
    {
        return $this->hasMany(Room::class, 'hospital_id', 'id');
    }

    public function bed()
    {
        return $this->hasMany(Bed::class, 'hospital_id', 'id');
    }

    // public function referrals()
    // {
    //     return $this->hasMany(Referral::class, 'ref_from_hospital', 'id');
    // }

    public function assigned_user()
    {
        return $this->hasOne(AssignedUser::class, 'hospital_id', 'id');
    }

    //inverse
    public function user()
    {
        return $this->belongTo(User::class, 'user_id', 'id');
    }
}
