<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class AssignedUser extends Model
{
    protected $fillable = ['hospital_id', 'user_id', 'role', 'drrmo_id'];

    //inverse
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function hospital()
    {
        return $this->belongsTo(Hospital::class, 'hospital_id','id');
    }
}
